/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class GetVaultAccessPolicyRequestMarshaller
implements Marshaller<Request<GetVaultAccessPolicyRequest>, GetVaultAccessPolicyRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetVaultAccessPolicyRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetVaultAccessPolicyRequest> marshall(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) {
        if (getVaultAccessPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetVaultAccessPolicyRequest> request = new DefaultRequest<GetVaultAccessPolicyRequest>(getVaultAccessPolicyRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/access-policy";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", getVaultAccessPolicyRequest.getAccountId() == null ? "-" : getVaultAccessPolicyRequest.getAccountId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", getVaultAccessPolicyRequest.getVaultName());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

