/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class AbortMultipartUploadRequestMarshaller
implements Marshaller<Request<AbortMultipartUploadRequest>, AbortMultipartUploadRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AbortMultipartUploadRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AbortMultipartUploadRequest> marshall(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        if (abortMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AbortMultipartUploadRequest> request = new DefaultRequest<AbortMultipartUploadRequest>(abortMultipartUploadRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", abortMultipartUploadRequest.getAccountId() == null ? "-" : abortMultipartUploadRequest.getAccountId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", abortMultipartUploadRequest.getVaultName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "uploadId", abortMultipartUploadRequest.getUploadId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

