/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.InstanceAccess;
import com.amazonaws.services.gamelift.model.transform.InstanceCredentialsJsonMarshaller;

public class InstanceAccessJsonMarshaller {
    private static InstanceAccessJsonMarshaller instance;

    public void marshall(InstanceAccess instanceAccess, StructuredJsonGenerator jsonGenerator) {
        if (instanceAccess == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (instanceAccess.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(instanceAccess.getFleetId());
            }
            if (instanceAccess.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(instanceAccess.getInstanceId());
            }
            if (instanceAccess.getIpAddress() != null) {
                jsonGenerator.writeFieldName("IpAddress").writeValue(instanceAccess.getIpAddress());
            }
            if (instanceAccess.getOperatingSystem() != null) {
                jsonGenerator.writeFieldName("OperatingSystem").writeValue(instanceAccess.getOperatingSystem());
            }
            if (instanceAccess.getCredentials() != null) {
                jsonGenerator.writeFieldName("Credentials");
                InstanceCredentialsJsonMarshaller.getInstance().marshall(instanceAccess.getCredentials(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceAccessJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceAccessJsonMarshaller();
        }
        return instance;
    }
}

