/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.DescribeRuntimeConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeRuntimeConfigurationRequestMarshaller
implements Marshaller<Request<DescribeRuntimeConfigurationRequest>, DescribeRuntimeConfigurationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeRuntimeConfigurationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeRuntimeConfigurationRequest> marshall(DescribeRuntimeConfigurationRequest describeRuntimeConfigurationRequest) {
        if (describeRuntimeConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeRuntimeConfigurationRequest> request = new DefaultRequest<DescribeRuntimeConfigurationRequest>(describeRuntimeConfigurationRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeRuntimeConfiguration");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeRuntimeConfigurationRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(describeRuntimeConfigurationRequest.getFleetId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

