/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListInstancesRequestMarshaller
implements Marshaller<Request<ListInstancesRequest>, ListInstancesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListInstancesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListInstancesRequest> marshall(ListInstancesRequest listInstancesRequest) {
        if (listInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListInstancesRequest> request = new DefaultRequest<ListInstancesRequest>(listInstancesRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList instanceStatesList;
            SdkInternalList instanceGroupTypesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listInstancesRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(listInstancesRequest.getClusterId());
            }
            if (listInstancesRequest.getInstanceGroupId() != null) {
                jsonGenerator.writeFieldName("InstanceGroupId").writeValue(listInstancesRequest.getInstanceGroupId());
            }
            if (!(instanceGroupTypesList = (SdkInternalList)listInstancesRequest.getInstanceGroupTypes()).isEmpty() || !instanceGroupTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceGroupTypes");
                jsonGenerator.writeStartArray();
                for (Object instanceGroupTypesListValue : instanceGroupTypesList) {
                    if (instanceGroupTypesListValue == null) continue;
                    jsonGenerator.writeValue((String)instanceGroupTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(instanceStatesList = (SdkInternalList)listInstancesRequest.getInstanceStates()).isEmpty() || !instanceStatesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceStates");
                jsonGenerator.writeStartArray();
                for (String instanceStatesListValue : instanceStatesList) {
                    if (instanceStatesListValue == null) continue;
                    jsonGenerator.writeValue(instanceStatesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listInstancesRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listInstancesRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

