/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.CloudWatchAlarmDefinition;
import com.amazonaws.services.elasticmapreduce.model.MetricDimension;
import com.amazonaws.services.elasticmapreduce.model.transform.MetricDimensionJsonMarshaller;

public class CloudWatchAlarmDefinitionJsonMarshaller {
    private static CloudWatchAlarmDefinitionJsonMarshaller instance;

    public void marshall(CloudWatchAlarmDefinition cloudWatchAlarmDefinition, StructuredJsonGenerator jsonGenerator) {
        if (cloudWatchAlarmDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList dimensionsList;
            jsonGenerator.writeStartObject();
            if (cloudWatchAlarmDefinition.getComparisonOperator() != null) {
                jsonGenerator.writeFieldName("ComparisonOperator").writeValue(cloudWatchAlarmDefinition.getComparisonOperator());
            }
            if (cloudWatchAlarmDefinition.getEvaluationPeriods() != null) {
                jsonGenerator.writeFieldName("EvaluationPeriods").writeValue(cloudWatchAlarmDefinition.getEvaluationPeriods());
            }
            if (cloudWatchAlarmDefinition.getMetricName() != null) {
                jsonGenerator.writeFieldName("MetricName").writeValue(cloudWatchAlarmDefinition.getMetricName());
            }
            if (cloudWatchAlarmDefinition.getNamespace() != null) {
                jsonGenerator.writeFieldName("Namespace").writeValue(cloudWatchAlarmDefinition.getNamespace());
            }
            if (cloudWatchAlarmDefinition.getPeriod() != null) {
                jsonGenerator.writeFieldName("Period").writeValue(cloudWatchAlarmDefinition.getPeriod());
            }
            if (cloudWatchAlarmDefinition.getStatistic() != null) {
                jsonGenerator.writeFieldName("Statistic").writeValue(cloudWatchAlarmDefinition.getStatistic());
            }
            if (cloudWatchAlarmDefinition.getThreshold() != null) {
                jsonGenerator.writeFieldName("Threshold").writeValue(cloudWatchAlarmDefinition.getThreshold());
            }
            if (cloudWatchAlarmDefinition.getUnit() != null) {
                jsonGenerator.writeFieldName("Unit").writeValue(cloudWatchAlarmDefinition.getUnit());
            }
            if (!(dimensionsList = (SdkInternalList)cloudWatchAlarmDefinition.getDimensions()).isEmpty() || !dimensionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Dimensions");
                jsonGenerator.writeStartArray();
                for (MetricDimension dimensionsListValue : dimensionsList) {
                    if (dimensionsListValue == null) continue;
                    MetricDimensionJsonMarshaller.getInstance().marshall(dimensionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CloudWatchAlarmDefinitionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CloudWatchAlarmDefinitionJsonMarshaller();
        }
        return instance;
    }
}

