/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.ListImagesRequest;
import com.amazonaws.services.ecr.model.transform.ListImagesFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListImagesRequestMarshaller
implements Marshaller<Request<ListImagesRequest>, ListImagesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListImagesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListImagesRequest> marshall(ListImagesRequest listImagesRequest) {
        if (listImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListImagesRequest> request = new DefaultRequest<ListImagesRequest>(listImagesRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.ListImages");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listImagesRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(listImagesRequest.getRegistryId());
            }
            if (listImagesRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(listImagesRequest.getRepositoryName());
            }
            if (listImagesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listImagesRequest.getNextToken());
            }
            if (listImagesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listImagesRequest.getMaxResults());
            }
            if (listImagesRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                ListImagesFilterJsonMarshaller.getInstance().marshall(listImagesRequest.getFilter(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

