/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.StartSchemaExtensionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class StartSchemaExtensionRequestMarshaller
implements Marshaller<Request<StartSchemaExtensionRequest>, StartSchemaExtensionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public StartSchemaExtensionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StartSchemaExtensionRequest> marshall(StartSchemaExtensionRequest startSchemaExtensionRequest) {
        if (startSchemaExtensionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartSchemaExtensionRequest> request = new DefaultRequest<StartSchemaExtensionRequest>(startSchemaExtensionRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.StartSchemaExtension");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (startSchemaExtensionRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(startSchemaExtensionRequest.getDirectoryId());
            }
            if (startSchemaExtensionRequest.getCreateSnapshotBeforeSchemaExtension() != null) {
                jsonGenerator.writeFieldName("CreateSnapshotBeforeSchemaExtension").writeValue(startSchemaExtensionRequest.getCreateSnapshotBeforeSchemaExtension());
            }
            if (startSchemaExtensionRequest.getLdifContent() != null) {
                jsonGenerator.writeFieldName("LdifContent").writeValue(startSchemaExtensionRequest.getLdifContent());
            }
            if (startSchemaExtensionRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(startSchemaExtensionRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

