/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AllocateConnectionOnInterconnectRequestMarshaller
implements Marshaller<Request<AllocateConnectionOnInterconnectRequest>, AllocateConnectionOnInterconnectRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AllocateConnectionOnInterconnectRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AllocateConnectionOnInterconnectRequest> marshall(AllocateConnectionOnInterconnectRequest allocateConnectionOnInterconnectRequest) {
        if (allocateConnectionOnInterconnectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AllocateConnectionOnInterconnectRequest> request = new DefaultRequest<AllocateConnectionOnInterconnectRequest>(allocateConnectionOnInterconnectRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.AllocateConnectionOnInterconnect");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (allocateConnectionOnInterconnectRequest.getBandwidth() != null) {
                jsonGenerator.writeFieldName("bandwidth").writeValue(allocateConnectionOnInterconnectRequest.getBandwidth());
            }
            if (allocateConnectionOnInterconnectRequest.getConnectionName() != null) {
                jsonGenerator.writeFieldName("connectionName").writeValue(allocateConnectionOnInterconnectRequest.getConnectionName());
            }
            if (allocateConnectionOnInterconnectRequest.getOwnerAccount() != null) {
                jsonGenerator.writeFieldName("ownerAccount").writeValue(allocateConnectionOnInterconnectRequest.getOwnerAccount());
            }
            if (allocateConnectionOnInterconnectRequest.getInterconnectId() != null) {
                jsonGenerator.writeFieldName("interconnectId").writeValue(allocateConnectionOnInterconnectRequest.getInterconnectId());
            }
            if (allocateConnectionOnInterconnectRequest.getVlan() != null) {
                jsonGenerator.writeFieldName("vlan").writeValue(allocateConnectionOnInterconnectRequest.getVlan());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

