/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribePipelinesRequestMarshaller
implements Marshaller<Request<DescribePipelinesRequest>, DescribePipelinesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribePipelinesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribePipelinesRequest> marshall(DescribePipelinesRequest describePipelinesRequest) {
        if (describePipelinesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribePipelinesRequest> request = new DefaultRequest<DescribePipelinesRequest>(describePipelinesRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.DescribePipelines");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList pipelineIdsList = (SdkInternalList)describePipelinesRequest.getPipelineIds();
            if (!pipelineIdsList.isEmpty() || !pipelineIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("pipelineIds");
                jsonGenerator.writeStartArray();
                for (String pipelineIdsListValue : pipelineIdsList) {
                    if (pipelineIdsListValue == null) continue;
                    jsonGenerator.writeValue(pipelineIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

