/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.ImportCertificateRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ImportCertificateRequestMarshaller
implements Marshaller<Request<ImportCertificateRequest>, ImportCertificateRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ImportCertificateRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ImportCertificateRequest> marshall(ImportCertificateRequest importCertificateRequest) {
        if (importCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportCertificateRequest> request = new DefaultRequest<ImportCertificateRequest>(importCertificateRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.ImportCertificate");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (importCertificateRequest.getCertificateIdentifier() != null) {
                jsonGenerator.writeFieldName("CertificateIdentifier").writeValue(importCertificateRequest.getCertificateIdentifier());
            }
            if (importCertificateRequest.getCertificatePem() != null) {
                jsonGenerator.writeFieldName("CertificatePem").writeValue(importCertificateRequest.getCertificatePem());
            }
            if (importCertificateRequest.getCertificateWallet() != null) {
                jsonGenerator.writeFieldName("CertificateWallet").writeValue(importCertificateRequest.getCertificateWallet());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

