/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetDeploymentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDeploymentsRequestMarshaller
implements Marshaller<Request<GetDeploymentsRequest>, GetDeploymentsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetDeploymentsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDeploymentsRequest> marshall(GetDeploymentsRequest getDeploymentsRequest) {
        if (getDeploymentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDeploymentsRequest> request = new DefaultRequest<GetDeploymentsRequest>(getDeploymentsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/deployments";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", getDeploymentsRequest.getRestApiId());
        request.setResourcePath(uriResourcePath);
        if (getDeploymentsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getDeploymentsRequest.getPosition()));
        }
        if (getDeploymentsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getDeploymentsRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

