/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.GenerateClientCertificateRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GenerateClientCertificateRequestMarshaller
implements Marshaller<Request<GenerateClientCertificateRequest>, GenerateClientCertificateRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GenerateClientCertificateRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GenerateClientCertificateRequest> marshall(GenerateClientCertificateRequest generateClientCertificateRequest) {
        if (generateClientCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateClientCertificateRequest> request = new DefaultRequest<GenerateClientCertificateRequest>(generateClientCertificateRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/clientcertificates";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (generateClientCertificateRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(generateClientCertificateRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

