/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.Association;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationOverviewJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.TargetJsonMarshaller;

public class AssociationJsonMarshaller {
    private static AssociationJsonMarshaller instance;

    public void marshall(Association association, StructuredJsonGenerator jsonGenerator) {
        if (association == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList targetsList;
            jsonGenerator.writeStartObject();
            if (association.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(association.getName());
            }
            if (association.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(association.getInstanceId());
            }
            if (association.getAssociationId() != null) {
                jsonGenerator.writeFieldName("AssociationId").writeValue(association.getAssociationId());
            }
            if (association.getDocumentVersion() != null) {
                jsonGenerator.writeFieldName("DocumentVersion").writeValue(association.getDocumentVersion());
            }
            if (!(targetsList = (SdkInternalList)association.getTargets()).isEmpty() || !targetsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Targets");
                jsonGenerator.writeStartArray();
                for (Target targetsListValue : targetsList) {
                    if (targetsListValue == null) continue;
                    TargetJsonMarshaller.getInstance().marshall(targetsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (association.getLastExecutionDate() != null) {
                jsonGenerator.writeFieldName("LastExecutionDate").writeValue(association.getLastExecutionDate());
            }
            if (association.getOverview() != null) {
                jsonGenerator.writeFieldName("Overview");
                AssociationOverviewJsonMarshaller.getInstance().marshall(association.getOverview(), jsonGenerator);
            }
            if (association.getScheduleExpression() != null) {
                jsonGenerator.writeFieldName("ScheduleExpression").writeValue(association.getScheduleExpression());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssociationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssociationJsonMarshaller();
        }
        return instance;
    }
}

