/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ConstraintSummary;
import com.amazonaws.services.servicecatalog.model.LaunchPathSummary;
import com.amazonaws.services.servicecatalog.model.Tag;
import com.amazonaws.services.servicecatalog.model.transform.ConstraintSummaryJsonMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.TagJsonMarshaller;
import java.util.List;

public class LaunchPathSummaryJsonMarshaller {
    private static LaunchPathSummaryJsonMarshaller instance;

    public void marshall(LaunchPathSummary launchPathSummary, StructuredJsonGenerator jsonGenerator) {
        if (launchPathSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Tag> tagsList;
            List<ConstraintSummary> constraintSummariesList;
            jsonGenerator.writeStartObject();
            if (launchPathSummary.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(launchPathSummary.getId());
            }
            if ((constraintSummariesList = launchPathSummary.getConstraintSummaries()) != null) {
                jsonGenerator.writeFieldName("ConstraintSummaries");
                jsonGenerator.writeStartArray();
                for (ConstraintSummary constraintSummariesListValue : constraintSummariesList) {
                    if (constraintSummariesListValue == null) continue;
                    ConstraintSummaryJsonMarshaller.getInstance().marshall(constraintSummariesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((tagsList = launchPathSummary.getTags()) != null) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (launchPathSummary.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(launchPathSummary.getName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LaunchPathSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LaunchPathSummaryJsonMarshaller();
        }
        return instance;
    }
}

