/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model;

import com.amazonaws.services.servermigration.model.ConnectorCapability;
import com.amazonaws.services.servermigration.model.ConnectorStatus;
import com.amazonaws.services.servermigration.model.VmManagerType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Connector
implements Serializable,
Cloneable {
    private String connectorId;
    private String version;
    private String status;
    private List<String> capabilityList;
    private String vmManagerName;
    private String vmManagerType;
    private String vmManagerId;
    private String ipAddress;
    private String macAddress;
    private Date associatedOn;

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public Connector withConnectorId(String connectorId) {
        this.setConnectorId(connectorId);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Connector withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Connector withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(ConnectorStatus status) {
        this.status = status.toString();
    }

    public Connector withStatus(ConnectorStatus status) {
        this.setStatus(status);
        return this;
    }

    public List<String> getCapabilityList() {
        return this.capabilityList;
    }

    public void setCapabilityList(Collection<String> capabilityList) {
        if (capabilityList == null) {
            this.capabilityList = null;
            return;
        }
        this.capabilityList = new ArrayList<String>(capabilityList);
    }

    public Connector withCapabilityList(String ... capabilityList) {
        if (this.capabilityList == null) {
            this.setCapabilityList(new ArrayList<String>(capabilityList.length));
        }
        for (String ele : capabilityList) {
            this.capabilityList.add(ele);
        }
        return this;
    }

    public Connector withCapabilityList(Collection<String> capabilityList) {
        this.setCapabilityList(capabilityList);
        return this;
    }

    public Connector withCapabilityList(ConnectorCapability ... capabilityList) {
        ArrayList<String> capabilityListCopy = new ArrayList<String>(capabilityList.length);
        for (ConnectorCapability value : capabilityList) {
            capabilityListCopy.add(value.toString());
        }
        if (this.getCapabilityList() == null) {
            this.setCapabilityList(capabilityListCopy);
        } else {
            this.getCapabilityList().addAll(capabilityListCopy);
        }
        return this;
    }

    public void setVmManagerName(String vmManagerName) {
        this.vmManagerName = vmManagerName;
    }

    public String getVmManagerName() {
        return this.vmManagerName;
    }

    public Connector withVmManagerName(String vmManagerName) {
        this.setVmManagerName(vmManagerName);
        return this;
    }

    public void setVmManagerType(String vmManagerType) {
        this.vmManagerType = vmManagerType;
    }

    public String getVmManagerType() {
        return this.vmManagerType;
    }

    public Connector withVmManagerType(String vmManagerType) {
        this.setVmManagerType(vmManagerType);
        return this;
    }

    public void setVmManagerType(VmManagerType vmManagerType) {
        this.vmManagerType = vmManagerType.toString();
    }

    public Connector withVmManagerType(VmManagerType vmManagerType) {
        this.setVmManagerType(vmManagerType);
        return this;
    }

    public void setVmManagerId(String vmManagerId) {
        this.vmManagerId = vmManagerId;
    }

    public String getVmManagerId() {
        return this.vmManagerId;
    }

    public Connector withVmManagerId(String vmManagerId) {
        this.setVmManagerId(vmManagerId);
        return this;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Connector withIpAddress(String ipAddress) {
        this.setIpAddress(ipAddress);
        return this;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public Connector withMacAddress(String macAddress) {
        this.setMacAddress(macAddress);
        return this;
    }

    public void setAssociatedOn(Date associatedOn) {
        this.associatedOn = associatedOn;
    }

    public Date getAssociatedOn() {
        return this.associatedOn;
    }

    public Connector withAssociatedOn(Date associatedOn) {
        this.setAssociatedOn(associatedOn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnectorId() != null) {
            sb.append("ConnectorId: ").append(this.getConnectorId()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCapabilityList() != null) {
            sb.append("CapabilityList: ").append(this.getCapabilityList()).append(",");
        }
        if (this.getVmManagerName() != null) {
            sb.append("VmManagerName: ").append(this.getVmManagerName()).append(",");
        }
        if (this.getVmManagerType() != null) {
            sb.append("VmManagerType: ").append(this.getVmManagerType()).append(",");
        }
        if (this.getVmManagerId() != null) {
            sb.append("VmManagerId: ").append(this.getVmManagerId()).append(",");
        }
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: ").append(this.getIpAddress()).append(",");
        }
        if (this.getMacAddress() != null) {
            sb.append("MacAddress: ").append(this.getMacAddress()).append(",");
        }
        if (this.getAssociatedOn() != null) {
            sb.append("AssociatedOn: ").append(this.getAssociatedOn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)obj;
        if (other.getConnectorId() == null ^ this.getConnectorId() == null) {
            return false;
        }
        if (other.getConnectorId() != null && !other.getConnectorId().equals(this.getConnectorId())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCapabilityList() == null ^ this.getCapabilityList() == null) {
            return false;
        }
        if (other.getCapabilityList() != null && !other.getCapabilityList().equals(this.getCapabilityList())) {
            return false;
        }
        if (other.getVmManagerName() == null ^ this.getVmManagerName() == null) {
            return false;
        }
        if (other.getVmManagerName() != null && !other.getVmManagerName().equals(this.getVmManagerName())) {
            return false;
        }
        if (other.getVmManagerType() == null ^ this.getVmManagerType() == null) {
            return false;
        }
        if (other.getVmManagerType() != null && !other.getVmManagerType().equals(this.getVmManagerType())) {
            return false;
        }
        if (other.getVmManagerId() == null ^ this.getVmManagerId() == null) {
            return false;
        }
        if (other.getVmManagerId() != null && !other.getVmManagerId().equals(this.getVmManagerId())) {
            return false;
        }
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        if (other.getIpAddress() != null && !other.getIpAddress().equals(this.getIpAddress())) {
            return false;
        }
        if (other.getMacAddress() == null ^ this.getMacAddress() == null) {
            return false;
        }
        if (other.getMacAddress() != null && !other.getMacAddress().equals(this.getMacAddress())) {
            return false;
        }
        if (other.getAssociatedOn() == null ^ this.getAssociatedOn() == null) {
            return false;
        }
        return other.getAssociatedOn() == null || other.getAssociatedOn().equals(this.getAssociatedOn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnectorId() == null ? 0 : this.getConnectorId().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilityList() == null ? 0 : this.getCapabilityList().hashCode());
        hashCode = 31 * hashCode + (this.getVmManagerName() == null ? 0 : this.getVmManagerName().hashCode());
        hashCode = 31 * hashCode + (this.getVmManagerType() == null ? 0 : this.getVmManagerType().hashCode());
        hashCode = 31 * hashCode + (this.getVmManagerId() == null ? 0 : this.getVmManagerId().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getMacAddress() == null ? 0 : this.getMacAddress().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedOn() == null ? 0 : this.getAssociatedOn().hashCode());
        return hashCode;
    }

    public Connector clone() {
        try {
            return (Connector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

