/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Face;
import com.amazonaws.services.rekognition.model.transform.BoundingBoxJsonMarshaller;

public class FaceJsonMarshaller {
    private static FaceJsonMarshaller instance;

    public void marshall(Face face, StructuredJsonGenerator jsonGenerator) {
        if (face == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (face.getFaceId() != null) {
                jsonGenerator.writeFieldName("FaceId").writeValue(face.getFaceId());
            }
            if (face.getBoundingBox() != null) {
                jsonGenerator.writeFieldName("BoundingBox");
                BoundingBoxJsonMarshaller.getInstance().marshall(face.getBoundingBox(), jsonGenerator);
            }
            if (face.getImageId() != null) {
                jsonGenerator.writeFieldName("ImageId").writeValue(face.getImageId());
            }
            if (face.getExternalImageId() != null) {
                jsonGenerator.writeFieldName("ExternalImageId").writeValue(face.getExternalImageId());
            }
            if (face.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(face.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FaceJsonMarshaller();
        }
        return instance;
    }
}

