/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.DetectLabelsRequest;
import com.amazonaws.services.rekognition.model.transform.ImageJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DetectLabelsRequestMarshaller
implements Marshaller<Request<DetectLabelsRequest>, DetectLabelsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DetectLabelsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DetectLabelsRequest> marshall(DetectLabelsRequest detectLabelsRequest) {
        if (detectLabelsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DetectLabelsRequest> request = new DefaultRequest<DetectLabelsRequest>(detectLabelsRequest, "AmazonRekognition");
        request.addHeader("X-Amz-Target", "RekognitionService.DetectLabels");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (detectLabelsRequest.getImage() != null) {
                jsonGenerator.writeFieldName("Image");
                ImageJsonMarshaller.getInstance().marshall(detectLabelsRequest.getImage(), jsonGenerator);
            }
            if (detectLabelsRequest.getMaxLabels() != null) {
                jsonGenerator.writeFieldName("MaxLabels").writeValue(detectLabelsRequest.getMaxLabels());
            }
            if (detectLabelsRequest.getMinConfidence() != null) {
                jsonGenerator.writeFieldName("MinConfidence").writeValue(detectLabelsRequest.getMinConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

