/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecommerceanalytics.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class GenerateDataSetRequestMarshaller
implements Marshaller<Request<GenerateDataSetRequest>, GenerateDataSetRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GenerateDataSetRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GenerateDataSetRequest> marshall(GenerateDataSetRequest generateDataSetRequest) {
        if (generateDataSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateDataSetRequest> request = new DefaultRequest<GenerateDataSetRequest>(generateDataSetRequest, "AWSMarketplaceCommerceAnalytics");
        request.addHeader("X-Amz-Target", "MarketplaceCommerceAnalytics20150701.GenerateDataSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> customerDefinedValuesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (generateDataSetRequest.getDataSetType() != null) {
                jsonGenerator.writeFieldName("dataSetType").writeValue(generateDataSetRequest.getDataSetType());
            }
            if (generateDataSetRequest.getDataSetPublicationDate() != null) {
                jsonGenerator.writeFieldName("dataSetPublicationDate").writeValue(generateDataSetRequest.getDataSetPublicationDate());
            }
            if (generateDataSetRequest.getRoleNameArn() != null) {
                jsonGenerator.writeFieldName("roleNameArn").writeValue(generateDataSetRequest.getRoleNameArn());
            }
            if (generateDataSetRequest.getDestinationS3BucketName() != null) {
                jsonGenerator.writeFieldName("destinationS3BucketName").writeValue(generateDataSetRequest.getDestinationS3BucketName());
            }
            if (generateDataSetRequest.getDestinationS3Prefix() != null) {
                jsonGenerator.writeFieldName("destinationS3Prefix").writeValue(generateDataSetRequest.getDestinationS3Prefix());
            }
            if (generateDataSetRequest.getSnsTopicArn() != null) {
                jsonGenerator.writeFieldName("snsTopicArn").writeValue(generateDataSetRequest.getSnsTopicArn());
            }
            if ((customerDefinedValuesMap = generateDataSetRequest.getCustomerDefinedValues()) != null) {
                jsonGenerator.writeFieldName("customerDefinedValues");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> customerDefinedValuesMapValue : customerDefinedValuesMap.entrySet()) {
                    if (customerDefinedValuesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(customerDefinedValuesMapValue.getKey());
                    jsonGenerator.writeValue(customerDefinedValuesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

