/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class CreateLogGroupRequestMarshaller
implements Marshaller<Request<CreateLogGroupRequest>, CreateLogGroupRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateLogGroupRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateLogGroupRequest> marshall(CreateLogGroupRequest createLogGroupRequest) {
        if (createLogGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLogGroupRequest> request = new DefaultRequest<CreateLogGroupRequest>(createLogGroupRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.CreateLogGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalMap tagsMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createLogGroupRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(createLogGroupRequest.getLogGroupName());
            }
            if (!(tagsMap = (SdkInternalMap)createLogGroupRequest.getTags()).isEmpty() || !tagsMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartObject();
                for (Map.Entry tagsMapValue : tagsMap.entrySet()) {
                    if (tagsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)tagsMapValue.getKey());
                    jsonGenerator.writeValue((String)tagsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

