/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.GetDomainsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetDomainsRequestMarshaller
implements Marshaller<Request<GetDomainsRequest>, GetDomainsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetDomainsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDomainsRequest> marshall(GetDomainsRequest getDomainsRequest) {
        if (getDomainsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDomainsRequest> request = new DefaultRequest<GetDomainsRequest>(getDomainsRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.GetDomains");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getDomainsRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("pageToken").writeValue(getDomainsRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

