/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.CreateApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.Input;
import com.amazonaws.services.kinesisanalytics.model.Output;
import com.amazonaws.services.kinesisanalytics.model.transform.InputJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.OutputJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateApplicationRequestMarshaller
implements Marshaller<Request<CreateApplicationRequest>, CreateApplicationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateApplicationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateApplicationRequest> marshall(CreateApplicationRequest createApplicationRequest) {
        if (createApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateApplicationRequest> request = new DefaultRequest<CreateApplicationRequest>(createApplicationRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.CreateApplication");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Output> outputsList;
            List<Input> inputsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createApplicationRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(createApplicationRequest.getApplicationName());
            }
            if (createApplicationRequest.getApplicationDescription() != null) {
                jsonGenerator.writeFieldName("ApplicationDescription").writeValue(createApplicationRequest.getApplicationDescription());
            }
            if ((inputsList = createApplicationRequest.getInputs()) != null) {
                jsonGenerator.writeFieldName("Inputs");
                jsonGenerator.writeStartArray();
                for (Input input : inputsList) {
                    if (input == null) continue;
                    InputJsonMarshaller.getInstance().marshall(input, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((outputsList = createApplicationRequest.getOutputs()) != null) {
                jsonGenerator.writeFieldName("Outputs");
                jsonGenerator.writeStartArray();
                for (Output outputsListValue : outputsList) {
                    if (outputsListValue == null) continue;
                    OutputJsonMarshaller.getInstance().marshall(outputsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createApplicationRequest.getApplicationCode() != null) {
                jsonGenerator.writeFieldName("ApplicationCode").writeValue(createApplicationRequest.getApplicationCode());
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

