/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class ReadPresetRequestMarshaller
implements Marshaller<Request<ReadPresetRequest>, ReadPresetRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ReadPresetRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ReadPresetRequest> marshall(ReadPresetRequest readPresetRequest) {
        if (readPresetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReadPresetRequest> request = new DefaultRequest<ReadPresetRequest>(readPresetRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2012-09-25/presets/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", readPresetRequest.getId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

