/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model;

import com.amazonaws.services.elasticsearch.model.OptionStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AdvancedOptionsStatus
implements Serializable,
Cloneable {
    private Map<String, String> options;
    private OptionStatus status;

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public AdvancedOptionsStatus withOptions(Map<String, String> options) {
        this.setOptions(options);
        return this;
    }

    public AdvancedOptionsStatus addOptionsEntry(String key, String value) {
        if (null == this.options) {
            this.options = new HashMap<String, String>();
        }
        if (this.options.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.options.put(key, value);
        return this;
    }

    public AdvancedOptionsStatus clearOptionsEntries() {
        this.options = null;
        return this;
    }

    public void setStatus(OptionStatus status) {
        this.status = status;
    }

    public OptionStatus getStatus() {
        return this.status;
    }

    public AdvancedOptionsStatus withStatus(OptionStatus status) {
        this.setStatus(status);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedOptionsStatus)) {
            return false;
        }
        AdvancedOptionsStatus other = (AdvancedOptionsStatus)obj;
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        if (other.getOptions() != null && !other.getOptions().equals(this.getOptions())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public AdvancedOptionsStatus clone() {
        try {
            return (AdvancedOptionsStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

