/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.MaxAgeRule;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MaxAgeRuleStaxUnmarshaller
implements Unmarshaller<MaxAgeRule, StaxUnmarshallerContext> {
    private static MaxAgeRuleStaxUnmarshaller instance;

    @Override
    public MaxAgeRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        MaxAgeRule maxAgeRule = new MaxAgeRule();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return maxAgeRule;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    maxAgeRule.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxAgeInDays", targetDepth)) {
                    maxAgeRule.setMaxAgeInDays(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DeleteSourceFromS3", targetDepth)) continue;
                maxAgeRule.setDeleteSourceFromS3(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return maxAgeRule;
    }

    public static MaxAgeRuleStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MaxAgeRuleStaxUnmarshaller();
        }
        return instance;
    }
}

