/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.PlacementConstraint;
import com.amazonaws.services.ecs.model.PlacementStrategy;
import com.amazonaws.services.ecs.model.transform.DeploymentConfigurationJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.LoadBalancerJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.PlacementConstraintJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.PlacementStrategyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateServiceRequestMarshaller
implements Marshaller<Request<CreateServiceRequest>, CreateServiceRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateServiceRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateServiceRequest> marshall(CreateServiceRequest createServiceRequest) {
        if (createServiceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateServiceRequest> request = new DefaultRequest<CreateServiceRequest>(createServiceRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.CreateService");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList placementStrategyList;
            SdkInternalList placementConstraintsList;
            SdkInternalList loadBalancersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createServiceRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(createServiceRequest.getCluster());
            }
            if (createServiceRequest.getServiceName() != null) {
                jsonGenerator.writeFieldName("serviceName").writeValue(createServiceRequest.getServiceName());
            }
            if (createServiceRequest.getTaskDefinition() != null) {
                jsonGenerator.writeFieldName("taskDefinition").writeValue(createServiceRequest.getTaskDefinition());
            }
            if (!(loadBalancersList = (SdkInternalList)createServiceRequest.getLoadBalancers()).isEmpty() || !loadBalancersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("loadBalancers");
                jsonGenerator.writeStartArray();
                for (Object loadBalancersListValue : loadBalancersList) {
                    if (loadBalancersListValue == null) continue;
                    LoadBalancerJsonMarshaller.getInstance().marshall((LoadBalancer)loadBalancersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createServiceRequest.getDesiredCount() != null) {
                jsonGenerator.writeFieldName("desiredCount").writeValue(createServiceRequest.getDesiredCount());
            }
            if (createServiceRequest.getClientToken() != null) {
                jsonGenerator.writeFieldName("clientToken").writeValue(createServiceRequest.getClientToken());
            }
            if (createServiceRequest.getRole() != null) {
                jsonGenerator.writeFieldName("role").writeValue(createServiceRequest.getRole());
            }
            if (createServiceRequest.getDeploymentConfiguration() != null) {
                jsonGenerator.writeFieldName("deploymentConfiguration");
                DeploymentConfigurationJsonMarshaller.getInstance().marshall(createServiceRequest.getDeploymentConfiguration(), jsonGenerator);
            }
            if (!(placementConstraintsList = (SdkInternalList)createServiceRequest.getPlacementConstraints()).isEmpty() || !placementConstraintsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("placementConstraints");
                jsonGenerator.writeStartArray();
                for (Object placementConstraintsListValue : placementConstraintsList) {
                    if (placementConstraintsListValue == null) continue;
                    PlacementConstraintJsonMarshaller.getInstance().marshall((PlacementConstraint)placementConstraintsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(placementStrategyList = (SdkInternalList)createServiceRequest.getPlacementStrategy()).isEmpty() || !placementStrategyList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("placementStrategy");
                jsonGenerator.writeStartArray();
                for (PlacementStrategy placementStrategyListValue : placementStrategyList) {
                    if (placementStrategyListValue == null) continue;
                    PlacementStrategyJsonMarshaller.getInstance().marshall(placementStrategyListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

