/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListStreamsRequestMarshaller
implements Marshaller<Request<ListStreamsRequest>, ListStreamsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListStreamsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListStreamsRequest> marshall(ListStreamsRequest listStreamsRequest) {
        if (listStreamsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStreamsRequest> request = new DefaultRequest<ListStreamsRequest>(listStreamsRequest, "AmazonDynamoDBStreams");
        request.addHeader("X-Amz-Target", "DynamoDBStreams_20120810.ListStreams");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listStreamsRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(listStreamsRequest.getTableName());
            }
            if (listStreamsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listStreamsRequest.getLimit());
            }
            if (listStreamsRequest.getExclusiveStartStreamArn() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartStreamArn").writeValue(listStreamsRequest.getExclusiveStartStreamArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

