/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.LookupAttribute;
import com.amazonaws.services.cloudtrail.model.LookupEventsRequest;
import com.amazonaws.services.cloudtrail.model.transform.LookupAttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class LookupEventsRequestMarshaller
implements Marshaller<Request<LookupEventsRequest>, LookupEventsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public LookupEventsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<LookupEventsRequest> marshall(LookupEventsRequest lookupEventsRequest) {
        if (lookupEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<LookupEventsRequest> request = new DefaultRequest<LookupEventsRequest>(lookupEventsRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.LookupEvents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList lookupAttributesList = (SdkInternalList)lookupEventsRequest.getLookupAttributes();
            if (!lookupAttributesList.isEmpty() || !lookupAttributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("LookupAttributes");
                jsonGenerator.writeStartArray();
                for (LookupAttribute lookupAttributesListValue : lookupAttributesList) {
                    if (lookupAttributesListValue == null) continue;
                    LookupAttributeJsonMarshaller.getInstance().marshall(lookupAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (lookupEventsRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(lookupEventsRequest.getStartTime());
            }
            if (lookupEventsRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(lookupEventsRequest.getEndTime());
            }
            if (lookupEventsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(lookupEventsRequest.getMaxResults());
            }
            if (lookupEventsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(lookupEventsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

