/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.UpdateSubscriberRequest;
import com.amazonaws.services.budgets.model.transform.NotificationJsonMarshaller;
import com.amazonaws.services.budgets.model.transform.SubscriberJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateSubscriberRequestMarshaller
implements Marshaller<Request<UpdateSubscriberRequest>, UpdateSubscriberRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateSubscriberRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateSubscriberRequest> marshall(UpdateSubscriberRequest updateSubscriberRequest) {
        if (updateSubscriberRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateSubscriberRequest> request = new DefaultRequest<UpdateSubscriberRequest>(updateSubscriberRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.UpdateSubscriber");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateSubscriberRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(updateSubscriberRequest.getAccountId());
            }
            if (updateSubscriberRequest.getBudgetName() != null) {
                jsonGenerator.writeFieldName("BudgetName").writeValue(updateSubscriberRequest.getBudgetName());
            }
            if (updateSubscriberRequest.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(updateSubscriberRequest.getNotification(), jsonGenerator);
            }
            if (updateSubscriberRequest.getOldSubscriber() != null) {
                jsonGenerator.writeFieldName("OldSubscriber");
                SubscriberJsonMarshaller.getInstance().marshall(updateSubscriberRequest.getOldSubscriber(), jsonGenerator);
            }
            if (updateSubscriberRequest.getNewSubscriber() != null) {
                jsonGenerator.writeFieldName("NewSubscriber");
                SubscriberJsonMarshaller.getInstance().marshall(updateSubscriberRequest.getNewSubscriber(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

