/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.UpdateOpenIDConnectProviderThumbprintRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateOpenIDConnectProviderThumbprintRequestMarshaller
implements Marshaller<Request<UpdateOpenIDConnectProviderThumbprintRequest>, UpdateOpenIDConnectProviderThumbprintRequest> {
    @Override
    public Request<UpdateOpenIDConnectProviderThumbprintRequest> marshall(UpdateOpenIDConnectProviderThumbprintRequest updateOpenIDConnectProviderThumbprintRequest) {
        SdkInternalList thumbprintListList;
        if (updateOpenIDConnectProviderThumbprintRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateOpenIDConnectProviderThumbprintRequest> request = new DefaultRequest<UpdateOpenIDConnectProviderThumbprintRequest>(updateOpenIDConnectProviderThumbprintRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "UpdateOpenIDConnectProviderThumbprint");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateOpenIDConnectProviderThumbprintRequest.getOpenIDConnectProviderArn() != null) {
            request.addParameter("OpenIDConnectProviderArn", StringUtils.fromString(updateOpenIDConnectProviderThumbprintRequest.getOpenIDConnectProviderArn()));
        }
        if (!(thumbprintListList = (SdkInternalList)updateOpenIDConnectProviderThumbprintRequest.getThumbprintList()).isEmpty() || !thumbprintListList.isAutoConstruct()) {
            int thumbprintListListIndex = 1;
            for (String thumbprintListListValue : thumbprintListList) {
                if (thumbprintListListValue != null) {
                    request.addParameter("ThumbprintList.member." + thumbprintListListIndex, StringUtils.fromString(thumbprintListListValue));
                }
                ++thumbprintListListIndex;
            }
        }
        return request;
    }
}

