/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.CreateInterconnectRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateInterconnectRequestMarshaller
implements Marshaller<Request<CreateInterconnectRequest>, CreateInterconnectRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateInterconnectRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateInterconnectRequest> marshall(CreateInterconnectRequest createInterconnectRequest) {
        if (createInterconnectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInterconnectRequest> request = new DefaultRequest<CreateInterconnectRequest>(createInterconnectRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.CreateInterconnect");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createInterconnectRequest.getInterconnectName() != null) {
                jsonGenerator.writeFieldName("interconnectName").writeValue(createInterconnectRequest.getInterconnectName());
            }
            if (createInterconnectRequest.getBandwidth() != null) {
                jsonGenerator.writeFieldName("bandwidth").writeValue(createInterconnectRequest.getBandwidth());
            }
            if (createInterconnectRequest.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(createInterconnectRequest.getLocation());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

