/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.ValidationError;
import com.amazonaws.services.datapipeline.model.ValidationWarning;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutPipelineDefinitionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ValidationError> validationErrors;
    private SdkInternalList<ValidationWarning> validationWarnings;
    private Boolean errored;

    public List<ValidationError> getValidationErrors() {
        if (this.validationErrors == null) {
            this.validationErrors = new SdkInternalList();
        }
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<ValidationError> validationErrors) {
        if (validationErrors == null) {
            this.validationErrors = null;
            return;
        }
        this.validationErrors = new SdkInternalList<ValidationError>(validationErrors);
    }

    public PutPipelineDefinitionResult withValidationErrors(ValidationError ... validationErrors) {
        if (this.validationErrors == null) {
            this.setValidationErrors(new SdkInternalList<ValidationError>(validationErrors.length));
        }
        for (ValidationError ele : validationErrors) {
            this.validationErrors.add(ele);
        }
        return this;
    }

    public PutPipelineDefinitionResult withValidationErrors(Collection<ValidationError> validationErrors) {
        this.setValidationErrors(validationErrors);
        return this;
    }

    public List<ValidationWarning> getValidationWarnings() {
        if (this.validationWarnings == null) {
            this.validationWarnings = new SdkInternalList();
        }
        return this.validationWarnings;
    }

    public void setValidationWarnings(Collection<ValidationWarning> validationWarnings) {
        if (validationWarnings == null) {
            this.validationWarnings = null;
            return;
        }
        this.validationWarnings = new SdkInternalList<ValidationWarning>(validationWarnings);
    }

    public PutPipelineDefinitionResult withValidationWarnings(ValidationWarning ... validationWarnings) {
        if (this.validationWarnings == null) {
            this.setValidationWarnings(new SdkInternalList<ValidationWarning>(validationWarnings.length));
        }
        for (ValidationWarning ele : validationWarnings) {
            this.validationWarnings.add(ele);
        }
        return this;
    }

    public PutPipelineDefinitionResult withValidationWarnings(Collection<ValidationWarning> validationWarnings) {
        this.setValidationWarnings(validationWarnings);
        return this;
    }

    public void setErrored(Boolean errored) {
        this.errored = errored;
    }

    public Boolean getErrored() {
        return this.errored;
    }

    public PutPipelineDefinitionResult withErrored(Boolean errored) {
        this.setErrored(errored);
        return this;
    }

    public Boolean isErrored() {
        return this.errored;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValidationErrors() != null) {
            sb.append("ValidationErrors: " + this.getValidationErrors() + ",");
        }
        if (this.getValidationWarnings() != null) {
            sb.append("ValidationWarnings: " + this.getValidationWarnings() + ",");
        }
        if (this.getErrored() != null) {
            sb.append("Errored: " + this.getErrored());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPipelineDefinitionResult)) {
            return false;
        }
        PutPipelineDefinitionResult other = (PutPipelineDefinitionResult)obj;
        if (other.getValidationErrors() == null ^ this.getValidationErrors() == null) {
            return false;
        }
        if (other.getValidationErrors() != null && !other.getValidationErrors().equals(this.getValidationErrors())) {
            return false;
        }
        if (other.getValidationWarnings() == null ^ this.getValidationWarnings() == null) {
            return false;
        }
        if (other.getValidationWarnings() != null && !other.getValidationWarnings().equals(this.getValidationWarnings())) {
            return false;
        }
        if (other.getErrored() == null ^ this.getErrored() == null) {
            return false;
        }
        return other.getErrored() == null || other.getErrored().equals(this.getErrored());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValidationErrors() == null ? 0 : this.getValidationErrors().hashCode());
        hashCode = 31 * hashCode + (this.getValidationWarnings() == null ? 0 : this.getValidationWarnings().hashCode());
        hashCode = 31 * hashCode + (this.getErrored() == null ? 0 : this.getErrored().hashCode());
        return hashCode;
    }

    public PutPipelineDefinitionResult clone() {
        try {
            return (PutPipelineDefinitionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

