/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.CreateUserImportJobRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateUserImportJobRequestMarshaller
implements Marshaller<Request<CreateUserImportJobRequest>, CreateUserImportJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateUserImportJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateUserImportJobRequest> marshall(CreateUserImportJobRequest createUserImportJobRequest) {
        if (createUserImportJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateUserImportJobRequest> request = new DefaultRequest<CreateUserImportJobRequest>(createUserImportJobRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.CreateUserImportJob");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createUserImportJobRequest.getJobName() != null) {
                jsonGenerator.writeFieldName("JobName").writeValue(createUserImportJobRequest.getJobName());
            }
            if (createUserImportJobRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(createUserImportJobRequest.getUserPoolId());
            }
            if (createUserImportJobRequest.getCloudWatchLogsRoleArn() != null) {
                jsonGenerator.writeFieldName("CloudWatchLogsRoleArn").writeValue(createUserImportJobRequest.getCloudWatchLogsRoleArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

