/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.CreateConstraintRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;

public class CreateConstraintRequestMarshaller
implements Marshaller<Request<CreateConstraintRequest>, CreateConstraintRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateConstraintRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateConstraintRequest> marshall(CreateConstraintRequest createConstraintRequest) {
        if (createConstraintRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateConstraintRequest> request = new DefaultRequest<CreateConstraintRequest>(createConstraintRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.CreateConstraint");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createConstraintRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(createConstraintRequest.getAcceptLanguage());
            }
            if (createConstraintRequest.getPortfolioId() != null) {
                jsonGenerator.writeFieldName("PortfolioId").writeValue(createConstraintRequest.getPortfolioId());
            }
            if (createConstraintRequest.getProductId() != null) {
                jsonGenerator.writeFieldName("ProductId").writeValue(createConstraintRequest.getProductId());
            }
            if (createConstraintRequest.getParameters() != null) {
                jsonGenerator.writeFieldName("Parameters").writeValue(createConstraintRequest.getParameters());
            }
            if (createConstraintRequest.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(createConstraintRequest.getType());
            }
            if (createConstraintRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createConstraintRequest.getDescription());
            }
            jsonGenerator.writeFieldName("IdempotencyToken").writeValue(IdempotentUtils.resolveString(createConstraintRequest.getIdempotencyToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

