/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.servicecatalog.AWSServiceCatalogAsync;
import com.amazonaws.services.servicecatalog.AWSServiceCatalogClient;
import com.amazonaws.services.servicecatalog.model.AcceptPortfolioShareRequest;
import com.amazonaws.services.servicecatalog.model.AcceptPortfolioShareResult;
import com.amazonaws.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest;
import com.amazonaws.services.servicecatalog.model.AssociatePrincipalWithPortfolioResult;
import com.amazonaws.services.servicecatalog.model.AssociateProductWithPortfolioRequest;
import com.amazonaws.services.servicecatalog.model.AssociateProductWithPortfolioResult;
import com.amazonaws.services.servicecatalog.model.CreateConstraintRequest;
import com.amazonaws.services.servicecatalog.model.CreateConstraintResult;
import com.amazonaws.services.servicecatalog.model.CreatePortfolioRequest;
import com.amazonaws.services.servicecatalog.model.CreatePortfolioResult;
import com.amazonaws.services.servicecatalog.model.CreatePortfolioShareRequest;
import com.amazonaws.services.servicecatalog.model.CreatePortfolioShareResult;
import com.amazonaws.services.servicecatalog.model.CreateProductRequest;
import com.amazonaws.services.servicecatalog.model.CreateProductResult;
import com.amazonaws.services.servicecatalog.model.CreateProvisioningArtifactRequest;
import com.amazonaws.services.servicecatalog.model.CreateProvisioningArtifactResult;
import com.amazonaws.services.servicecatalog.model.DeleteConstraintRequest;
import com.amazonaws.services.servicecatalog.model.DeleteConstraintResult;
import com.amazonaws.services.servicecatalog.model.DeletePortfolioRequest;
import com.amazonaws.services.servicecatalog.model.DeletePortfolioResult;
import com.amazonaws.services.servicecatalog.model.DeletePortfolioShareRequest;
import com.amazonaws.services.servicecatalog.model.DeletePortfolioShareResult;
import com.amazonaws.services.servicecatalog.model.DeleteProductRequest;
import com.amazonaws.services.servicecatalog.model.DeleteProductResult;
import com.amazonaws.services.servicecatalog.model.DeleteProvisioningArtifactRequest;
import com.amazonaws.services.servicecatalog.model.DeleteProvisioningArtifactResult;
import com.amazonaws.services.servicecatalog.model.DescribeConstraintRequest;
import com.amazonaws.services.servicecatalog.model.DescribeConstraintResult;
import com.amazonaws.services.servicecatalog.model.DescribePortfolioRequest;
import com.amazonaws.services.servicecatalog.model.DescribePortfolioResult;
import com.amazonaws.services.servicecatalog.model.DescribeProductAsAdminRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProductAsAdminResult;
import com.amazonaws.services.servicecatalog.model.DescribeProductRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProductResult;
import com.amazonaws.services.servicecatalog.model.DescribeProductViewRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProductViewResult;
import com.amazonaws.services.servicecatalog.model.DescribeProvisioningArtifactRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProvisioningArtifactResult;
import com.amazonaws.services.servicecatalog.model.DescribeProvisioningParametersRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProvisioningParametersResult;
import com.amazonaws.services.servicecatalog.model.DescribeRecordRequest;
import com.amazonaws.services.servicecatalog.model.DescribeRecordResult;
import com.amazonaws.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest;
import com.amazonaws.services.servicecatalog.model.DisassociatePrincipalFromPortfolioResult;
import com.amazonaws.services.servicecatalog.model.DisassociateProductFromPortfolioRequest;
import com.amazonaws.services.servicecatalog.model.DisassociateProductFromPortfolioResult;
import com.amazonaws.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import com.amazonaws.services.servicecatalog.model.ListAcceptedPortfolioSharesResult;
import com.amazonaws.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import com.amazonaws.services.servicecatalog.model.ListConstraintsForPortfolioResult;
import com.amazonaws.services.servicecatalog.model.ListLaunchPathsRequest;
import com.amazonaws.services.servicecatalog.model.ListLaunchPathsResult;
import com.amazonaws.services.servicecatalog.model.ListPortfolioAccessRequest;
import com.amazonaws.services.servicecatalog.model.ListPortfolioAccessResult;
import com.amazonaws.services.servicecatalog.model.ListPortfoliosForProductRequest;
import com.amazonaws.services.servicecatalog.model.ListPortfoliosForProductResult;
import com.amazonaws.services.servicecatalog.model.ListPortfoliosRequest;
import com.amazonaws.services.servicecatalog.model.ListPortfoliosResult;
import com.amazonaws.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import com.amazonaws.services.servicecatalog.model.ListPrincipalsForPortfolioResult;
import com.amazonaws.services.servicecatalog.model.ListProvisioningArtifactsRequest;
import com.amazonaws.services.servicecatalog.model.ListProvisioningArtifactsResult;
import com.amazonaws.services.servicecatalog.model.ListRecordHistoryRequest;
import com.amazonaws.services.servicecatalog.model.ListRecordHistoryResult;
import com.amazonaws.services.servicecatalog.model.ProvisionProductRequest;
import com.amazonaws.services.servicecatalog.model.ProvisionProductResult;
import com.amazonaws.services.servicecatalog.model.RejectPortfolioShareRequest;
import com.amazonaws.services.servicecatalog.model.RejectPortfolioShareResult;
import com.amazonaws.services.servicecatalog.model.ScanProvisionedProductsRequest;
import com.amazonaws.services.servicecatalog.model.ScanProvisionedProductsResult;
import com.amazonaws.services.servicecatalog.model.SearchProductsAsAdminRequest;
import com.amazonaws.services.servicecatalog.model.SearchProductsAsAdminResult;
import com.amazonaws.services.servicecatalog.model.SearchProductsRequest;
import com.amazonaws.services.servicecatalog.model.SearchProductsResult;
import com.amazonaws.services.servicecatalog.model.TerminateProvisionedProductRequest;
import com.amazonaws.services.servicecatalog.model.TerminateProvisionedProductResult;
import com.amazonaws.services.servicecatalog.model.UpdateConstraintRequest;
import com.amazonaws.services.servicecatalog.model.UpdateConstraintResult;
import com.amazonaws.services.servicecatalog.model.UpdatePortfolioRequest;
import com.amazonaws.services.servicecatalog.model.UpdatePortfolioResult;
import com.amazonaws.services.servicecatalog.model.UpdateProductRequest;
import com.amazonaws.services.servicecatalog.model.UpdateProductResult;
import com.amazonaws.services.servicecatalog.model.UpdateProvisionedProductRequest;
import com.amazonaws.services.servicecatalog.model.UpdateProvisionedProductResult;
import com.amazonaws.services.servicecatalog.model.UpdateProvisioningArtifactRequest;
import com.amazonaws.services.servicecatalog.model.UpdateProvisioningArtifactResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSServiceCatalogAsyncClient
extends AWSServiceCatalogClient
implements AWSServiceCatalogAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSServiceCatalogAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AWSServiceCatalogAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSServiceCatalogAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSServiceCatalogAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSServiceCatalogAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSServiceCatalogAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSServiceCatalogAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSServiceCatalogAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSServiceCatalogAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSServiceCatalogAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptPortfolioShareResult> acceptPortfolioShareAsync(AcceptPortfolioShareRequest request) {
        return this.acceptPortfolioShareAsync(request, null);
    }

    @Override
    public Future<AcceptPortfolioShareResult> acceptPortfolioShareAsync(final AcceptPortfolioShareRequest request, final AsyncHandler<AcceptPortfolioShareRequest, AcceptPortfolioShareResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcceptPortfolioShareResult>(){

            @Override
            public AcceptPortfolioShareResult call() throws Exception {
                AcceptPortfolioShareResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.acceptPortfolioShare(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociatePrincipalWithPortfolioResult> associatePrincipalWithPortfolioAsync(AssociatePrincipalWithPortfolioRequest request) {
        return this.associatePrincipalWithPortfolioAsync(request, null);
    }

    @Override
    public Future<AssociatePrincipalWithPortfolioResult> associatePrincipalWithPortfolioAsync(final AssociatePrincipalWithPortfolioRequest request, final AsyncHandler<AssociatePrincipalWithPortfolioRequest, AssociatePrincipalWithPortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssociatePrincipalWithPortfolioResult>(){

            @Override
            public AssociatePrincipalWithPortfolioResult call() throws Exception {
                AssociatePrincipalWithPortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.associatePrincipalWithPortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateProductWithPortfolioResult> associateProductWithPortfolioAsync(AssociateProductWithPortfolioRequest request) {
        return this.associateProductWithPortfolioAsync(request, null);
    }

    @Override
    public Future<AssociateProductWithPortfolioResult> associateProductWithPortfolioAsync(final AssociateProductWithPortfolioRequest request, final AsyncHandler<AssociateProductWithPortfolioRequest, AssociateProductWithPortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssociateProductWithPortfolioResult>(){

            @Override
            public AssociateProductWithPortfolioResult call() throws Exception {
                AssociateProductWithPortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.associateProductWithPortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateConstraintResult> createConstraintAsync(CreateConstraintRequest request) {
        return this.createConstraintAsync(request, null);
    }

    @Override
    public Future<CreateConstraintResult> createConstraintAsync(final CreateConstraintRequest request, final AsyncHandler<CreateConstraintRequest, CreateConstraintResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateConstraintResult>(){

            @Override
            public CreateConstraintResult call() throws Exception {
                CreateConstraintResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.createConstraint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePortfolioResult> createPortfolioAsync(CreatePortfolioRequest request) {
        return this.createPortfolioAsync(request, null);
    }

    @Override
    public Future<CreatePortfolioResult> createPortfolioAsync(final CreatePortfolioRequest request, final AsyncHandler<CreatePortfolioRequest, CreatePortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePortfolioResult>(){

            @Override
            public CreatePortfolioResult call() throws Exception {
                CreatePortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.createPortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePortfolioShareResult> createPortfolioShareAsync(CreatePortfolioShareRequest request) {
        return this.createPortfolioShareAsync(request, null);
    }

    @Override
    public Future<CreatePortfolioShareResult> createPortfolioShareAsync(final CreatePortfolioShareRequest request, final AsyncHandler<CreatePortfolioShareRequest, CreatePortfolioShareResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePortfolioShareResult>(){

            @Override
            public CreatePortfolioShareResult call() throws Exception {
                CreatePortfolioShareResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.createPortfolioShare(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProductResult> createProductAsync(CreateProductRequest request) {
        return this.createProductAsync(request, null);
    }

    @Override
    public Future<CreateProductResult> createProductAsync(final CreateProductRequest request, final AsyncHandler<CreateProductRequest, CreateProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateProductResult>(){

            @Override
            public CreateProductResult call() throws Exception {
                CreateProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.createProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProvisioningArtifactResult> createProvisioningArtifactAsync(CreateProvisioningArtifactRequest request) {
        return this.createProvisioningArtifactAsync(request, null);
    }

    @Override
    public Future<CreateProvisioningArtifactResult> createProvisioningArtifactAsync(final CreateProvisioningArtifactRequest request, final AsyncHandler<CreateProvisioningArtifactRequest, CreateProvisioningArtifactResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateProvisioningArtifactResult>(){

            @Override
            public CreateProvisioningArtifactResult call() throws Exception {
                CreateProvisioningArtifactResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.createProvisioningArtifact(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConstraintResult> deleteConstraintAsync(DeleteConstraintRequest request) {
        return this.deleteConstraintAsync(request, null);
    }

    @Override
    public Future<DeleteConstraintResult> deleteConstraintAsync(final DeleteConstraintRequest request, final AsyncHandler<DeleteConstraintRequest, DeleteConstraintResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteConstraintResult>(){

            @Override
            public DeleteConstraintResult call() throws Exception {
                DeleteConstraintResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.deleteConstraint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePortfolioResult> deletePortfolioAsync(DeletePortfolioRequest request) {
        return this.deletePortfolioAsync(request, null);
    }

    @Override
    public Future<DeletePortfolioResult> deletePortfolioAsync(final DeletePortfolioRequest request, final AsyncHandler<DeletePortfolioRequest, DeletePortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeletePortfolioResult>(){

            @Override
            public DeletePortfolioResult call() throws Exception {
                DeletePortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.deletePortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePortfolioShareResult> deletePortfolioShareAsync(DeletePortfolioShareRequest request) {
        return this.deletePortfolioShareAsync(request, null);
    }

    @Override
    public Future<DeletePortfolioShareResult> deletePortfolioShareAsync(final DeletePortfolioShareRequest request, final AsyncHandler<DeletePortfolioShareRequest, DeletePortfolioShareResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeletePortfolioShareResult>(){

            @Override
            public DeletePortfolioShareResult call() throws Exception {
                DeletePortfolioShareResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.deletePortfolioShare(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProductResult> deleteProductAsync(DeleteProductRequest request) {
        return this.deleteProductAsync(request, null);
    }

    @Override
    public Future<DeleteProductResult> deleteProductAsync(final DeleteProductRequest request, final AsyncHandler<DeleteProductRequest, DeleteProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteProductResult>(){

            @Override
            public DeleteProductResult call() throws Exception {
                DeleteProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.deleteProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProvisioningArtifactResult> deleteProvisioningArtifactAsync(DeleteProvisioningArtifactRequest request) {
        return this.deleteProvisioningArtifactAsync(request, null);
    }

    @Override
    public Future<DeleteProvisioningArtifactResult> deleteProvisioningArtifactAsync(final DeleteProvisioningArtifactRequest request, final AsyncHandler<DeleteProvisioningArtifactRequest, DeleteProvisioningArtifactResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteProvisioningArtifactResult>(){

            @Override
            public DeleteProvisioningArtifactResult call() throws Exception {
                DeleteProvisioningArtifactResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.deleteProvisioningArtifact(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConstraintResult> describeConstraintAsync(DescribeConstraintRequest request) {
        return this.describeConstraintAsync(request, null);
    }

    @Override
    public Future<DescribeConstraintResult> describeConstraintAsync(final DescribeConstraintRequest request, final AsyncHandler<DescribeConstraintRequest, DescribeConstraintResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConstraintResult>(){

            @Override
            public DescribeConstraintResult call() throws Exception {
                DescribeConstraintResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeConstraint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePortfolioResult> describePortfolioAsync(DescribePortfolioRequest request) {
        return this.describePortfolioAsync(request, null);
    }

    @Override
    public Future<DescribePortfolioResult> describePortfolioAsync(final DescribePortfolioRequest request, final AsyncHandler<DescribePortfolioRequest, DescribePortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribePortfolioResult>(){

            @Override
            public DescribePortfolioResult call() throws Exception {
                DescribePortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describePortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProductResult> describeProductAsync(DescribeProductRequest request) {
        return this.describeProductAsync(request, null);
    }

    @Override
    public Future<DescribeProductResult> describeProductAsync(final DescribeProductRequest request, final AsyncHandler<DescribeProductRequest, DescribeProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeProductResult>(){

            @Override
            public DescribeProductResult call() throws Exception {
                DescribeProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProductAsAdminResult> describeProductAsAdminAsync(DescribeProductAsAdminRequest request) {
        return this.describeProductAsAdminAsync(request, null);
    }

    @Override
    public Future<DescribeProductAsAdminResult> describeProductAsAdminAsync(final DescribeProductAsAdminRequest request, final AsyncHandler<DescribeProductAsAdminRequest, DescribeProductAsAdminResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeProductAsAdminResult>(){

            @Override
            public DescribeProductAsAdminResult call() throws Exception {
                DescribeProductAsAdminResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeProductAsAdmin(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProductViewResult> describeProductViewAsync(DescribeProductViewRequest request) {
        return this.describeProductViewAsync(request, null);
    }

    @Override
    public Future<DescribeProductViewResult> describeProductViewAsync(final DescribeProductViewRequest request, final AsyncHandler<DescribeProductViewRequest, DescribeProductViewResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeProductViewResult>(){

            @Override
            public DescribeProductViewResult call() throws Exception {
                DescribeProductViewResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeProductView(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProvisioningArtifactResult> describeProvisioningArtifactAsync(DescribeProvisioningArtifactRequest request) {
        return this.describeProvisioningArtifactAsync(request, null);
    }

    @Override
    public Future<DescribeProvisioningArtifactResult> describeProvisioningArtifactAsync(final DescribeProvisioningArtifactRequest request, final AsyncHandler<DescribeProvisioningArtifactRequest, DescribeProvisioningArtifactResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeProvisioningArtifactResult>(){

            @Override
            public DescribeProvisioningArtifactResult call() throws Exception {
                DescribeProvisioningArtifactResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeProvisioningArtifact(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProvisioningParametersResult> describeProvisioningParametersAsync(DescribeProvisioningParametersRequest request) {
        return this.describeProvisioningParametersAsync(request, null);
    }

    @Override
    public Future<DescribeProvisioningParametersResult> describeProvisioningParametersAsync(final DescribeProvisioningParametersRequest request, final AsyncHandler<DescribeProvisioningParametersRequest, DescribeProvisioningParametersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeProvisioningParametersResult>(){

            @Override
            public DescribeProvisioningParametersResult call() throws Exception {
                DescribeProvisioningParametersResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeProvisioningParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRecordResult> describeRecordAsync(DescribeRecordRequest request) {
        return this.describeRecordAsync(request, null);
    }

    @Override
    public Future<DescribeRecordResult> describeRecordAsync(final DescribeRecordRequest request, final AsyncHandler<DescribeRecordRequest, DescribeRecordResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeRecordResult>(){

            @Override
            public DescribeRecordResult call() throws Exception {
                DescribeRecordResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.describeRecord(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociatePrincipalFromPortfolioResult> disassociatePrincipalFromPortfolioAsync(DisassociatePrincipalFromPortfolioRequest request) {
        return this.disassociatePrincipalFromPortfolioAsync(request, null);
    }

    @Override
    public Future<DisassociatePrincipalFromPortfolioResult> disassociatePrincipalFromPortfolioAsync(final DisassociatePrincipalFromPortfolioRequest request, final AsyncHandler<DisassociatePrincipalFromPortfolioRequest, DisassociatePrincipalFromPortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisassociatePrincipalFromPortfolioResult>(){

            @Override
            public DisassociatePrincipalFromPortfolioResult call() throws Exception {
                DisassociatePrincipalFromPortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.disassociatePrincipalFromPortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateProductFromPortfolioResult> disassociateProductFromPortfolioAsync(DisassociateProductFromPortfolioRequest request) {
        return this.disassociateProductFromPortfolioAsync(request, null);
    }

    @Override
    public Future<DisassociateProductFromPortfolioResult> disassociateProductFromPortfolioAsync(final DisassociateProductFromPortfolioRequest request, final AsyncHandler<DisassociateProductFromPortfolioRequest, DisassociateProductFromPortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisassociateProductFromPortfolioResult>(){

            @Override
            public DisassociateProductFromPortfolioResult call() throws Exception {
                DisassociateProductFromPortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.disassociateProductFromPortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAcceptedPortfolioSharesResult> listAcceptedPortfolioSharesAsync(ListAcceptedPortfolioSharesRequest request) {
        return this.listAcceptedPortfolioSharesAsync(request, null);
    }

    @Override
    public Future<ListAcceptedPortfolioSharesResult> listAcceptedPortfolioSharesAsync(final ListAcceptedPortfolioSharesRequest request, final AsyncHandler<ListAcceptedPortfolioSharesRequest, ListAcceptedPortfolioSharesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAcceptedPortfolioSharesResult>(){

            @Override
            public ListAcceptedPortfolioSharesResult call() throws Exception {
                ListAcceptedPortfolioSharesResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listAcceptedPortfolioShares(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConstraintsForPortfolioResult> listConstraintsForPortfolioAsync(ListConstraintsForPortfolioRequest request) {
        return this.listConstraintsForPortfolioAsync(request, null);
    }

    @Override
    public Future<ListConstraintsForPortfolioResult> listConstraintsForPortfolioAsync(final ListConstraintsForPortfolioRequest request, final AsyncHandler<ListConstraintsForPortfolioRequest, ListConstraintsForPortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListConstraintsForPortfolioResult>(){

            @Override
            public ListConstraintsForPortfolioResult call() throws Exception {
                ListConstraintsForPortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listConstraintsForPortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLaunchPathsResult> listLaunchPathsAsync(ListLaunchPathsRequest request) {
        return this.listLaunchPathsAsync(request, null);
    }

    @Override
    public Future<ListLaunchPathsResult> listLaunchPathsAsync(final ListLaunchPathsRequest request, final AsyncHandler<ListLaunchPathsRequest, ListLaunchPathsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListLaunchPathsResult>(){

            @Override
            public ListLaunchPathsResult call() throws Exception {
                ListLaunchPathsResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listLaunchPaths(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPortfolioAccessResult> listPortfolioAccessAsync(ListPortfolioAccessRequest request) {
        return this.listPortfolioAccessAsync(request, null);
    }

    @Override
    public Future<ListPortfolioAccessResult> listPortfolioAccessAsync(final ListPortfolioAccessRequest request, final AsyncHandler<ListPortfolioAccessRequest, ListPortfolioAccessResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPortfolioAccessResult>(){

            @Override
            public ListPortfolioAccessResult call() throws Exception {
                ListPortfolioAccessResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listPortfolioAccess(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPortfoliosResult> listPortfoliosAsync(ListPortfoliosRequest request) {
        return this.listPortfoliosAsync(request, null);
    }

    @Override
    public Future<ListPortfoliosResult> listPortfoliosAsync(final ListPortfoliosRequest request, final AsyncHandler<ListPortfoliosRequest, ListPortfoliosResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPortfoliosResult>(){

            @Override
            public ListPortfoliosResult call() throws Exception {
                ListPortfoliosResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listPortfolios(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPortfoliosForProductResult> listPortfoliosForProductAsync(ListPortfoliosForProductRequest request) {
        return this.listPortfoliosForProductAsync(request, null);
    }

    @Override
    public Future<ListPortfoliosForProductResult> listPortfoliosForProductAsync(final ListPortfoliosForProductRequest request, final AsyncHandler<ListPortfoliosForProductRequest, ListPortfoliosForProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPortfoliosForProductResult>(){

            @Override
            public ListPortfoliosForProductResult call() throws Exception {
                ListPortfoliosForProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listPortfoliosForProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPrincipalsForPortfolioResult> listPrincipalsForPortfolioAsync(ListPrincipalsForPortfolioRequest request) {
        return this.listPrincipalsForPortfolioAsync(request, null);
    }

    @Override
    public Future<ListPrincipalsForPortfolioResult> listPrincipalsForPortfolioAsync(final ListPrincipalsForPortfolioRequest request, final AsyncHandler<ListPrincipalsForPortfolioRequest, ListPrincipalsForPortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPrincipalsForPortfolioResult>(){

            @Override
            public ListPrincipalsForPortfolioResult call() throws Exception {
                ListPrincipalsForPortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listPrincipalsForPortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProvisioningArtifactsResult> listProvisioningArtifactsAsync(ListProvisioningArtifactsRequest request) {
        return this.listProvisioningArtifactsAsync(request, null);
    }

    @Override
    public Future<ListProvisioningArtifactsResult> listProvisioningArtifactsAsync(final ListProvisioningArtifactsRequest request, final AsyncHandler<ListProvisioningArtifactsRequest, ListProvisioningArtifactsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListProvisioningArtifactsResult>(){

            @Override
            public ListProvisioningArtifactsResult call() throws Exception {
                ListProvisioningArtifactsResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listProvisioningArtifacts(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecordHistoryResult> listRecordHistoryAsync(ListRecordHistoryRequest request) {
        return this.listRecordHistoryAsync(request, null);
    }

    @Override
    public Future<ListRecordHistoryResult> listRecordHistoryAsync(final ListRecordHistoryRequest request, final AsyncHandler<ListRecordHistoryRequest, ListRecordHistoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRecordHistoryResult>(){

            @Override
            public ListRecordHistoryResult call() throws Exception {
                ListRecordHistoryResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.listRecordHistory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ProvisionProductResult> provisionProductAsync(ProvisionProductRequest request) {
        return this.provisionProductAsync(request, null);
    }

    @Override
    public Future<ProvisionProductResult> provisionProductAsync(final ProvisionProductRequest request, final AsyncHandler<ProvisionProductRequest, ProvisionProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<ProvisionProductResult>(){

            @Override
            public ProvisionProductResult call() throws Exception {
                ProvisionProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.provisionProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectPortfolioShareResult> rejectPortfolioShareAsync(RejectPortfolioShareRequest request) {
        return this.rejectPortfolioShareAsync(request, null);
    }

    @Override
    public Future<RejectPortfolioShareResult> rejectPortfolioShareAsync(final RejectPortfolioShareRequest request, final AsyncHandler<RejectPortfolioShareRequest, RejectPortfolioShareResult> asyncHandler) {
        return this.executorService.submit(new Callable<RejectPortfolioShareResult>(){

            @Override
            public RejectPortfolioShareResult call() throws Exception {
                RejectPortfolioShareResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.rejectPortfolioShare(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ScanProvisionedProductsResult> scanProvisionedProductsAsync(ScanProvisionedProductsRequest request) {
        return this.scanProvisionedProductsAsync(request, null);
    }

    @Override
    public Future<ScanProvisionedProductsResult> scanProvisionedProductsAsync(final ScanProvisionedProductsRequest request, final AsyncHandler<ScanProvisionedProductsRequest, ScanProvisionedProductsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ScanProvisionedProductsResult>(){

            @Override
            public ScanProvisionedProductsResult call() throws Exception {
                ScanProvisionedProductsResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.scanProvisionedProducts(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchProductsResult> searchProductsAsync(SearchProductsRequest request) {
        return this.searchProductsAsync(request, null);
    }

    @Override
    public Future<SearchProductsResult> searchProductsAsync(final SearchProductsRequest request, final AsyncHandler<SearchProductsRequest, SearchProductsResult> asyncHandler) {
        return this.executorService.submit(new Callable<SearchProductsResult>(){

            @Override
            public SearchProductsResult call() throws Exception {
                SearchProductsResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.searchProducts(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchProductsAsAdminResult> searchProductsAsAdminAsync(SearchProductsAsAdminRequest request) {
        return this.searchProductsAsAdminAsync(request, null);
    }

    @Override
    public Future<SearchProductsAsAdminResult> searchProductsAsAdminAsync(final SearchProductsAsAdminRequest request, final AsyncHandler<SearchProductsAsAdminRequest, SearchProductsAsAdminResult> asyncHandler) {
        return this.executorService.submit(new Callable<SearchProductsAsAdminResult>(){

            @Override
            public SearchProductsAsAdminResult call() throws Exception {
                SearchProductsAsAdminResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.searchProductsAsAdmin(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateProvisionedProductResult> terminateProvisionedProductAsync(TerminateProvisionedProductRequest request) {
        return this.terminateProvisionedProductAsync(request, null);
    }

    @Override
    public Future<TerminateProvisionedProductResult> terminateProvisionedProductAsync(final TerminateProvisionedProductRequest request, final AsyncHandler<TerminateProvisionedProductRequest, TerminateProvisionedProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<TerminateProvisionedProductResult>(){

            @Override
            public TerminateProvisionedProductResult call() throws Exception {
                TerminateProvisionedProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.terminateProvisionedProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConstraintResult> updateConstraintAsync(UpdateConstraintRequest request) {
        return this.updateConstraintAsync(request, null);
    }

    @Override
    public Future<UpdateConstraintResult> updateConstraintAsync(final UpdateConstraintRequest request, final AsyncHandler<UpdateConstraintRequest, UpdateConstraintResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateConstraintResult>(){

            @Override
            public UpdateConstraintResult call() throws Exception {
                UpdateConstraintResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.updateConstraint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePortfolioResult> updatePortfolioAsync(UpdatePortfolioRequest request) {
        return this.updatePortfolioAsync(request, null);
    }

    @Override
    public Future<UpdatePortfolioResult> updatePortfolioAsync(final UpdatePortfolioRequest request, final AsyncHandler<UpdatePortfolioRequest, UpdatePortfolioResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdatePortfolioResult>(){

            @Override
            public UpdatePortfolioResult call() throws Exception {
                UpdatePortfolioResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.updatePortfolio(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProductResult> updateProductAsync(UpdateProductRequest request) {
        return this.updateProductAsync(request, null);
    }

    @Override
    public Future<UpdateProductResult> updateProductAsync(final UpdateProductRequest request, final AsyncHandler<UpdateProductRequest, UpdateProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateProductResult>(){

            @Override
            public UpdateProductResult call() throws Exception {
                UpdateProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.updateProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProvisionedProductResult> updateProvisionedProductAsync(UpdateProvisionedProductRequest request) {
        return this.updateProvisionedProductAsync(request, null);
    }

    @Override
    public Future<UpdateProvisionedProductResult> updateProvisionedProductAsync(final UpdateProvisionedProductRequest request, final AsyncHandler<UpdateProvisionedProductRequest, UpdateProvisionedProductResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateProvisionedProductResult>(){

            @Override
            public UpdateProvisionedProductResult call() throws Exception {
                UpdateProvisionedProductResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.updateProvisionedProduct(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProvisioningArtifactResult> updateProvisioningArtifactAsync(UpdateProvisioningArtifactRequest request) {
        return this.updateProvisioningArtifactAsync(request, null);
    }

    @Override
    public Future<UpdateProvisioningArtifactResult> updateProvisioningArtifactAsync(final UpdateProvisioningArtifactRequest request, final AsyncHandler<UpdateProvisioningArtifactRequest, UpdateProvisioningArtifactResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateProvisioningArtifactResult>(){

            @Override
            public UpdateProvisioningArtifactResult call() throws Exception {
                UpdateProvisioningArtifactResult result;
                try {
                    result = AWSServiceCatalogAsyncClient.this.updateProvisioningArtifact(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

