/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.AccountSettings;
import java.util.Map;

public class AccountSettingsJsonMarshaller {
    private static AccountSettingsJsonMarshaller instance;

    public void marshall(AccountSettings accountSettings, StructuredJsonGenerator jsonGenerator) {
        if (accountSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Integer> unmeteredRemoteAccessDevicesMap;
            Map<String, Integer> unmeteredDevicesMap;
            jsonGenerator.writeStartObject();
            if (accountSettings.getAwsAccountNumber() != null) {
                jsonGenerator.writeFieldName("awsAccountNumber").writeValue(accountSettings.getAwsAccountNumber());
            }
            if ((unmeteredDevicesMap = accountSettings.getUnmeteredDevices()) != null) {
                jsonGenerator.writeFieldName("unmeteredDevices");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Integer> unmeteredDevicesMapValue : unmeteredDevicesMap.entrySet()) {
                    if (unmeteredDevicesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(unmeteredDevicesMapValue.getKey());
                    jsonGenerator.writeValue(unmeteredDevicesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((unmeteredRemoteAccessDevicesMap = accountSettings.getUnmeteredRemoteAccessDevices()) != null) {
                jsonGenerator.writeFieldName("unmeteredRemoteAccessDevices");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Integer> unmeteredRemoteAccessDevicesMapValue : unmeteredRemoteAccessDevicesMap.entrySet()) {
                    if (unmeteredRemoteAccessDevicesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(unmeteredRemoteAccessDevicesMapValue.getKey());
                    jsonGenerator.writeValue(unmeteredRemoteAccessDevicesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AccountSettingsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AccountSettingsJsonMarshaller();
        }
        return instance;
    }
}

