/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AttachLoadBalancersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String autoScalingGroupName;
    private SdkInternalList<String> loadBalancerNames;

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public AttachLoadBalancersRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    public List<String> getLoadBalancerNames() {
        if (this.loadBalancerNames == null) {
            this.loadBalancerNames = new SdkInternalList();
        }
        return this.loadBalancerNames;
    }

    public void setLoadBalancerNames(Collection<String> loadBalancerNames) {
        if (loadBalancerNames == null) {
            this.loadBalancerNames = null;
            return;
        }
        this.loadBalancerNames = new SdkInternalList<String>(loadBalancerNames);
    }

    public AttachLoadBalancersRequest withLoadBalancerNames(String ... loadBalancerNames) {
        if (this.loadBalancerNames == null) {
            this.setLoadBalancerNames(new SdkInternalList<String>(loadBalancerNames.length));
        }
        for (String ele : loadBalancerNames) {
            this.loadBalancerNames.add(ele);
        }
        return this;
    }

    public AttachLoadBalancersRequest withLoadBalancerNames(Collection<String> loadBalancerNames) {
        this.setLoadBalancerNames(loadBalancerNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: " + this.getAutoScalingGroupName() + ",");
        }
        if (this.getLoadBalancerNames() != null) {
            sb.append("LoadBalancerNames: " + this.getLoadBalancerNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachLoadBalancersRequest)) {
            return false;
        }
        AttachLoadBalancersRequest other = (AttachLoadBalancersRequest)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getLoadBalancerNames() == null ^ this.getLoadBalancerNames() == null) {
            return false;
        }
        return other.getLoadBalancerNames() == null || other.getLoadBalancerNames().equals(this.getLoadBalancerNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerNames() == null ? 0 : this.getLoadBalancerNames().hashCode());
        return hashCode;
    }

    @Override
    public AttachLoadBalancersRequest clone() {
        return (AttachLoadBalancersRequest)super.clone();
    }
}

