/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetModelTemplateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetModelTemplateRequestMarshaller
implements Marshaller<Request<GetModelTemplateRequest>, GetModelTemplateRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetModelTemplateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetModelTemplateRequest> marshall(GetModelTemplateRequest getModelTemplateRequest) {
        if (getModelTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetModelTemplateRequest> request = new DefaultRequest<GetModelTemplateRequest>(getModelTemplateRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/models/{model_name}/default_template";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getModelTemplateRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getModelTemplateRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{model_name}", getModelTemplateRequest.getModelName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getModelTemplateRequest.getModelName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

