/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.transform.CloseStatusFilterJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ExecutionTimeFilterJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionFilterJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListClosedWorkflowExecutionsRequestMarshaller
implements Marshaller<Request<ListClosedWorkflowExecutionsRequest>, ListClosedWorkflowExecutionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListClosedWorkflowExecutionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListClosedWorkflowExecutionsRequest> marshall(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) {
        if (listClosedWorkflowExecutionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListClosedWorkflowExecutionsRequest> request = new DefaultRequest<ListClosedWorkflowExecutionsRequest>(listClosedWorkflowExecutionsRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.ListClosedWorkflowExecutions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listClosedWorkflowExecutionsRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(listClosedWorkflowExecutionsRequest.getDomain());
            }
            if (listClosedWorkflowExecutionsRequest.getStartTimeFilter() != null) {
                jsonGenerator.writeFieldName("startTimeFilter");
                ExecutionTimeFilterJsonMarshaller.getInstance().marshall(listClosedWorkflowExecutionsRequest.getStartTimeFilter(), jsonGenerator);
            }
            if (listClosedWorkflowExecutionsRequest.getCloseTimeFilter() != null) {
                jsonGenerator.writeFieldName("closeTimeFilter");
                ExecutionTimeFilterJsonMarshaller.getInstance().marshall(listClosedWorkflowExecutionsRequest.getCloseTimeFilter(), jsonGenerator);
            }
            if (listClosedWorkflowExecutionsRequest.getExecutionFilter() != null) {
                jsonGenerator.writeFieldName("executionFilter");
                WorkflowExecutionFilterJsonMarshaller.getInstance().marshall(listClosedWorkflowExecutionsRequest.getExecutionFilter(), jsonGenerator);
            }
            if (listClosedWorkflowExecutionsRequest.getCloseStatusFilter() != null) {
                jsonGenerator.writeFieldName("closeStatusFilter");
                CloseStatusFilterJsonMarshaller.getInstance().marshall(listClosedWorkflowExecutionsRequest.getCloseStatusFilter(), jsonGenerator);
            }
            if (listClosedWorkflowExecutionsRequest.getTypeFilter() != null) {
                jsonGenerator.writeFieldName("typeFilter");
                WorkflowTypeFilterJsonMarshaller.getInstance().marshall(listClosedWorkflowExecutionsRequest.getTypeFilter(), jsonGenerator);
            }
            if (listClosedWorkflowExecutionsRequest.getTagFilter() != null) {
                jsonGenerator.writeFieldName("tagFilter");
                TagFilterJsonMarshaller.getInstance().marshall(listClosedWorkflowExecutionsRequest.getTagFilter(), jsonGenerator);
            }
            if (listClosedWorkflowExecutionsRequest.getNextPageToken() != null) {
                jsonGenerator.writeFieldName("nextPageToken").writeValue(listClosedWorkflowExecutionsRequest.getNextPageToken());
            }
            if (listClosedWorkflowExecutionsRequest.getMaximumPageSize() != null) {
                jsonGenerator.writeFieldName("maximumPageSize").writeValue(listClosedWorkflowExecutionsRequest.getMaximumPageSize());
            }
            if (listClosedWorkflowExecutionsRequest.getReverseOrder() != null) {
                jsonGenerator.writeFieldName("reverseOrder").writeValue(listClosedWorkflowExecutionsRequest.getReverseOrder());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

