/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.GetVaultLockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetVaultLockRequestMarshaller
implements Marshaller<Request<GetVaultLockRequest>, GetVaultLockRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetVaultLockRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetVaultLockRequest> marshall(GetVaultLockRequest getVaultLockRequest) {
        if (getVaultLockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetVaultLockRequest> request = new DefaultRequest<GetVaultLockRequest>(getVaultLockRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/lock-policy";
        uriResourcePath = uriResourcePath.replace("{accountId}", getVaultLockRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getVaultLockRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", getVaultLockRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getVaultLockRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

