/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncAsync;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.BulkPublishRequest;
import com.amazonaws.services.cognitosync.model.BulkPublishResult;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.GetBulkPublishDetailsRequest;
import com.amazonaws.services.cognitosync.model.GetBulkPublishDetailsResult;
import com.amazonaws.services.cognitosync.model.GetCognitoEventsRequest;
import com.amazonaws.services.cognitosync.model.GetCognitoEventsResult;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.SetCognitoEventsRequest;
import com.amazonaws.services.cognitosync.model.SetCognitoEventsResult;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetResult;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCognitoSyncAsyncClient
extends AmazonCognitoSyncClient
implements AmazonCognitoSyncAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCognitoSyncAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AmazonCognitoSyncAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonCognitoSyncAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BulkPublishResult> bulkPublishAsync(BulkPublishRequest request) {
        return this.bulkPublishAsync(request, null);
    }

    @Override
    public Future<BulkPublishResult> bulkPublishAsync(final BulkPublishRequest request, final AsyncHandler<BulkPublishRequest, BulkPublishResult> asyncHandler) {
        return this.executorService.submit(new Callable<BulkPublishResult>(){

            @Override
            public BulkPublishResult call() throws Exception {
                BulkPublishResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.bulkPublish(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(final DeleteDatasetRequest request, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.deleteDataset(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request) {
        return this.describeDatasetAsync(request, null);
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(final DescribeDatasetRequest request, final AsyncHandler<DescribeDatasetRequest, DescribeDatasetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                DescribeDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeDataset(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(DescribeIdentityPoolUsageRequest request) {
        return this.describeIdentityPoolUsageAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(final DescribeIdentityPoolUsageRequest request, final AsyncHandler<DescribeIdentityPoolUsageRequest, DescribeIdentityPoolUsageResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeIdentityPoolUsageResult>(){

            @Override
            public DescribeIdentityPoolUsageResult call() throws Exception {
                DescribeIdentityPoolUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeIdentityPoolUsage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(DescribeIdentityUsageRequest request) {
        return this.describeIdentityUsageAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(final DescribeIdentityUsageRequest request, final AsyncHandler<DescribeIdentityUsageRequest, DescribeIdentityUsageResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeIdentityUsageResult>(){

            @Override
            public DescribeIdentityUsageResult call() throws Exception {
                DescribeIdentityUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeIdentityUsage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBulkPublishDetailsResult> getBulkPublishDetailsAsync(GetBulkPublishDetailsRequest request) {
        return this.getBulkPublishDetailsAsync(request, null);
    }

    @Override
    public Future<GetBulkPublishDetailsResult> getBulkPublishDetailsAsync(final GetBulkPublishDetailsRequest request, final AsyncHandler<GetBulkPublishDetailsRequest, GetBulkPublishDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetBulkPublishDetailsResult>(){

            @Override
            public GetBulkPublishDetailsResult call() throws Exception {
                GetBulkPublishDetailsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.getBulkPublishDetails(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCognitoEventsResult> getCognitoEventsAsync(GetCognitoEventsRequest request) {
        return this.getCognitoEventsAsync(request, null);
    }

    @Override
    public Future<GetCognitoEventsResult> getCognitoEventsAsync(final GetCognitoEventsRequest request, final AsyncHandler<GetCognitoEventsRequest, GetCognitoEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCognitoEventsResult>(){

            @Override
            public GetCognitoEventsResult call() throws Exception {
                GetCognitoEventsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.getCognitoEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIdentityPoolConfigurationResult> getIdentityPoolConfigurationAsync(GetIdentityPoolConfigurationRequest request) {
        return this.getIdentityPoolConfigurationAsync(request, null);
    }

    @Override
    public Future<GetIdentityPoolConfigurationResult> getIdentityPoolConfigurationAsync(final GetIdentityPoolConfigurationRequest request, final AsyncHandler<GetIdentityPoolConfigurationRequest, GetIdentityPoolConfigurationResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetIdentityPoolConfigurationResult>(){

            @Override
            public GetIdentityPoolConfigurationResult call() throws Exception {
                GetIdentityPoolConfigurationResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.getIdentityPoolConfiguration(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request) {
        return this.listDatasetsAsync(request, null);
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(final ListDatasetsRequest request, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listDatasets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(ListIdentityPoolUsageRequest request) {
        return this.listIdentityPoolUsageAsync(request, null);
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(final ListIdentityPoolUsageRequest request, final AsyncHandler<ListIdentityPoolUsageRequest, ListIdentityPoolUsageResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListIdentityPoolUsageResult>(){

            @Override
            public ListIdentityPoolUsageResult call() throws Exception {
                ListIdentityPoolUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listIdentityPoolUsage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(ListRecordsRequest request) {
        return this.listRecordsAsync(request, null);
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(final ListRecordsRequest request, final AsyncHandler<ListRecordsRequest, ListRecordsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRecordsResult>(){

            @Override
            public ListRecordsResult call() throws Exception {
                ListRecordsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listRecords(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterDeviceResult> registerDeviceAsync(RegisterDeviceRequest request) {
        return this.registerDeviceAsync(request, null);
    }

    @Override
    public Future<RegisterDeviceResult> registerDeviceAsync(final RegisterDeviceRequest request, final AsyncHandler<RegisterDeviceRequest, RegisterDeviceResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterDeviceResult>(){

            @Override
            public RegisterDeviceResult call() throws Exception {
                RegisterDeviceResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.registerDevice(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetCognitoEventsResult> setCognitoEventsAsync(SetCognitoEventsRequest request) {
        return this.setCognitoEventsAsync(request, null);
    }

    @Override
    public Future<SetCognitoEventsResult> setCognitoEventsAsync(final SetCognitoEventsRequest request, final AsyncHandler<SetCognitoEventsRequest, SetCognitoEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetCognitoEventsResult>(){

            @Override
            public SetCognitoEventsResult call() throws Exception {
                SetCognitoEventsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.setCognitoEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetIdentityPoolConfigurationResult> setIdentityPoolConfigurationAsync(SetIdentityPoolConfigurationRequest request) {
        return this.setIdentityPoolConfigurationAsync(request, null);
    }

    @Override
    public Future<SetIdentityPoolConfigurationResult> setIdentityPoolConfigurationAsync(final SetIdentityPoolConfigurationRequest request, final AsyncHandler<SetIdentityPoolConfigurationRequest, SetIdentityPoolConfigurationResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetIdentityPoolConfigurationResult>(){

            @Override
            public SetIdentityPoolConfigurationResult call() throws Exception {
                SetIdentityPoolConfigurationResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.setIdentityPoolConfiguration(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubscribeToDatasetResult> subscribeToDatasetAsync(SubscribeToDatasetRequest request) {
        return this.subscribeToDatasetAsync(request, null);
    }

    @Override
    public Future<SubscribeToDatasetResult> subscribeToDatasetAsync(final SubscribeToDatasetRequest request, final AsyncHandler<SubscribeToDatasetRequest, SubscribeToDatasetResult> asyncHandler) {
        return this.executorService.submit(new Callable<SubscribeToDatasetResult>(){

            @Override
            public SubscribeToDatasetResult call() throws Exception {
                SubscribeToDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.subscribeToDataset(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnsubscribeFromDatasetResult> unsubscribeFromDatasetAsync(UnsubscribeFromDatasetRequest request) {
        return this.unsubscribeFromDatasetAsync(request, null);
    }

    @Override
    public Future<UnsubscribeFromDatasetResult> unsubscribeFromDatasetAsync(final UnsubscribeFromDatasetRequest request, final AsyncHandler<UnsubscribeFromDatasetRequest, UnsubscribeFromDatasetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UnsubscribeFromDatasetResult>(){

            @Override
            public UnsubscribeFromDatasetResult call() throws Exception {
                UnsubscribeFromDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.unsubscribeFromDataset(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(UpdateRecordsRequest request) {
        return this.updateRecordsAsync(request, null);
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(final UpdateRecordsRequest request, final AsyncHandler<UpdateRecordsRequest, UpdateRecordsResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateRecordsResult>(){

            @Override
            public UpdateRecordsResult call() throws Exception {
                UpdateRecordsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.updateRecords(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

