/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.CreateDeploymentGroupRequest;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.TriggerConfig;
import com.amazonaws.services.codedeploy.model.transform.AlarmConfigurationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.AutoRollbackConfigurationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.EC2TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TriggerConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateDeploymentGroupRequestMarshaller
implements Marshaller<Request<CreateDeploymentGroupRequest>, CreateDeploymentGroupRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDeploymentGroupRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDeploymentGroupRequest> marshall(CreateDeploymentGroupRequest createDeploymentGroupRequest) {
        if (createDeploymentGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDeploymentGroupRequest> request = new DefaultRequest<CreateDeploymentGroupRequest>(createDeploymentGroupRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.CreateDeploymentGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList triggerConfigurationsList;
            SdkInternalList autoScalingGroupsList;
            SdkInternalList onPremisesInstanceTagFiltersList;
            SdkInternalList ec2TagFiltersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDeploymentGroupRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(createDeploymentGroupRequest.getApplicationName());
            }
            if (createDeploymentGroupRequest.getDeploymentGroupName() != null) {
                jsonGenerator.writeFieldName("deploymentGroupName").writeValue(createDeploymentGroupRequest.getDeploymentGroupName());
            }
            if (createDeploymentGroupRequest.getDeploymentConfigName() != null) {
                jsonGenerator.writeFieldName("deploymentConfigName").writeValue(createDeploymentGroupRequest.getDeploymentConfigName());
            }
            if (!(ec2TagFiltersList = (SdkInternalList)createDeploymentGroupRequest.getEc2TagFilters()).isEmpty() || !ec2TagFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ec2TagFilters");
                jsonGenerator.writeStartArray();
                for (Object ec2TagFiltersListValue : ec2TagFiltersList) {
                    if (ec2TagFiltersListValue == null) continue;
                    EC2TagFilterJsonMarshaller.getInstance().marshall((EC2TagFilter)ec2TagFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(onPremisesInstanceTagFiltersList = (SdkInternalList)createDeploymentGroupRequest.getOnPremisesInstanceTagFilters()).isEmpty() || !onPremisesInstanceTagFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("onPremisesInstanceTagFilters");
                jsonGenerator.writeStartArray();
                for (Object onPremisesInstanceTagFiltersListValue : onPremisesInstanceTagFiltersList) {
                    if (onPremisesInstanceTagFiltersListValue == null) continue;
                    TagFilterJsonMarshaller.getInstance().marshall((TagFilter)onPremisesInstanceTagFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(autoScalingGroupsList = (SdkInternalList)createDeploymentGroupRequest.getAutoScalingGroups()).isEmpty() || !autoScalingGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("autoScalingGroups");
                jsonGenerator.writeStartArray();
                for (Object autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    jsonGenerator.writeValue((String)autoScalingGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createDeploymentGroupRequest.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("serviceRoleArn").writeValue(createDeploymentGroupRequest.getServiceRoleArn());
            }
            if (!(triggerConfigurationsList = (SdkInternalList)createDeploymentGroupRequest.getTriggerConfigurations()).isEmpty() || !triggerConfigurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("triggerConfigurations");
                jsonGenerator.writeStartArray();
                for (TriggerConfig triggerConfigurationsListValue : triggerConfigurationsList) {
                    if (triggerConfigurationsListValue == null) continue;
                    TriggerConfigJsonMarshaller.getInstance().marshall(triggerConfigurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createDeploymentGroupRequest.getAlarmConfiguration() != null) {
                jsonGenerator.writeFieldName("alarmConfiguration");
                AlarmConfigurationJsonMarshaller.getInstance().marshall(createDeploymentGroupRequest.getAlarmConfiguration(), jsonGenerator);
            }
            if (createDeploymentGroupRequest.getAutoRollbackConfiguration() != null) {
                jsonGenerator.writeFieldName("autoRollbackConfiguration");
                AutoRollbackConfigurationJsonMarshaller.getInstance().marshall(createDeploymentGroupRequest.getAutoRollbackConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

