/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.support.model.DescribeServicesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeServicesRequestMarshaller
implements Marshaller<Request<DescribeServicesRequest>, DescribeServicesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeServicesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeServicesRequest> marshall(DescribeServicesRequest describeServicesRequest) {
        if (describeServicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeServicesRequest> request = new DefaultRequest<DescribeServicesRequest>(describeServicesRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.DescribeServices");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList serviceCodeListList = (SdkInternalList)describeServicesRequest.getServiceCodeList();
            if (!serviceCodeListList.isEmpty() || !serviceCodeListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("serviceCodeList");
                jsonGenerator.writeStartArray();
                for (String serviceCodeListListValue : serviceCodeListList) {
                    if (serviceCodeListListValue == null) continue;
                    jsonGenerator.writeValue(serviceCodeListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeServicesRequest.getLanguage() != null) {
                jsonGenerator.writeFieldName("language").writeValue(describeServicesRequest.getLanguage());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

