/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class SignalWorkflowExecutionRequestMarshaller
implements Marshaller<Request<SignalWorkflowExecutionRequest>, SignalWorkflowExecutionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SignalWorkflowExecutionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SignalWorkflowExecutionRequest> marshall(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) {
        if (signalWorkflowExecutionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SignalWorkflowExecutionRequest> request = new DefaultRequest<SignalWorkflowExecutionRequest>(signalWorkflowExecutionRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.SignalWorkflowExecution");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (signalWorkflowExecutionRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(signalWorkflowExecutionRequest.getDomain());
            }
            if (signalWorkflowExecutionRequest.getWorkflowId() != null) {
                jsonGenerator.writeFieldName("workflowId").writeValue(signalWorkflowExecutionRequest.getWorkflowId());
            }
            if (signalWorkflowExecutionRequest.getRunId() != null) {
                jsonGenerator.writeFieldName("runId").writeValue(signalWorkflowExecutionRequest.getRunId());
            }
            if (signalWorkflowExecutionRequest.getSignalName() != null) {
                jsonGenerator.writeFieldName("signalName").writeValue(signalWorkflowExecutionRequest.getSignalName());
            }
            if (signalWorkflowExecutionRequest.getInput() != null) {
                jsonGenerator.writeFieldName("input").writeValue(signalWorkflowExecutionRequest.getInput());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

