/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.CreateActivationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateActivationRequestMarshaller
implements Marshaller<Request<CreateActivationRequest>, CreateActivationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateActivationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateActivationRequest> marshall(CreateActivationRequest createActivationRequest) {
        if (createActivationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateActivationRequest> request = new DefaultRequest<CreateActivationRequest>(createActivationRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.CreateActivation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createActivationRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createActivationRequest.getDescription());
            }
            if (createActivationRequest.getDefaultInstanceName() != null) {
                jsonGenerator.writeFieldName("DefaultInstanceName").writeValue(createActivationRequest.getDefaultInstanceName());
            }
            if (createActivationRequest.getIamRole() != null) {
                jsonGenerator.writeFieldName("IamRole").writeValue(createActivationRequest.getIamRole());
            }
            if (createActivationRequest.getRegistrationLimit() != null) {
                jsonGenerator.writeFieldName("RegistrationLimit").writeValue(createActivationRequest.getRegistrationLimit());
            }
            if (createActivationRequest.getExpirationDate() != null) {
                jsonGenerator.writeFieldName("ExpirationDate").writeValue(createActivationRequest.getExpirationDate());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

