/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationOutputRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteApplicationOutputRequestMarshaller
implements Marshaller<Request<DeleteApplicationOutputRequest>, DeleteApplicationOutputRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteApplicationOutputRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteApplicationOutputRequest> marshall(DeleteApplicationOutputRequest deleteApplicationOutputRequest) {
        if (deleteApplicationOutputRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteApplicationOutputRequest> request = new DefaultRequest<DeleteApplicationOutputRequest>(deleteApplicationOutputRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.DeleteApplicationOutput");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteApplicationOutputRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(deleteApplicationOutputRequest.getApplicationName());
            }
            if (deleteApplicationOutputRequest.getCurrentApplicationVersionId() != null) {
                jsonGenerator.writeFieldName("CurrentApplicationVersionId").writeValue(deleteApplicationOutputRequest.getCurrentApplicationVersionId());
            }
            if (deleteApplicationOutputRequest.getOutputId() != null) {
                jsonGenerator.writeFieldName("OutputId").writeValue(deleteApplicationOutputRequest.getOutputId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

