/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.ListThingTypesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListThingTypesRequestMarshaller
implements Marshaller<Request<ListThingTypesRequest>, ListThingTypesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListThingTypesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListThingTypesRequest> marshall(ListThingTypesRequest listThingTypesRequest) {
        if (listThingTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListThingTypesRequest> request = new DefaultRequest<ListThingTypesRequest>(listThingTypesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/thing-types";
        request.setResourcePath(uriResourcePath);
        if (listThingTypesRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString(listThingTypesRequest.getNextToken()));
        }
        if (listThingTypesRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger(listThingTypesRequest.getMaxResults()));
        }
        if (listThingTypesRequest.getThingTypeName() != null) {
            request.addParameter("thingTypeName", StringUtils.fromString(listThingTypesRequest.getThingTypeName()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

