/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.DeleteThingTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteThingTypeRequestMarshaller
implements Marshaller<Request<DeleteThingTypeRequest>, DeleteThingTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteThingTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteThingTypeRequest> marshall(DeleteThingTypeRequest deleteThingTypeRequest) {
        if (deleteThingTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteThingTypeRequest> request = new DefaultRequest<DeleteThingTypeRequest>(deleteThingTypeRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/thing-types/{thingTypeName}";
        uriResourcePath = uriResourcePath.replace("{thingTypeName}", deleteThingTypeRequest.getThingTypeName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteThingTypeRequest.getThingTypeName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

