/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.glacier.model.DescribeVaultOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListVaultsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DescribeVaultOutput> vaultList;
    private String marker;

    public List<DescribeVaultOutput> getVaultList() {
        return this.vaultList;
    }

    public void setVaultList(Collection<DescribeVaultOutput> vaultList) {
        if (vaultList == null) {
            this.vaultList = null;
            return;
        }
        this.vaultList = new ArrayList<DescribeVaultOutput>(vaultList);
    }

    public ListVaultsResult withVaultList(DescribeVaultOutput ... vaultList) {
        if (this.vaultList == null) {
            this.setVaultList(new ArrayList<DescribeVaultOutput>(vaultList.length));
        }
        for (DescribeVaultOutput ele : vaultList) {
            this.vaultList.add(ele);
        }
        return this;
    }

    public ListVaultsResult withVaultList(Collection<DescribeVaultOutput> vaultList) {
        this.setVaultList(vaultList);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListVaultsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVaultList() != null) {
            sb.append("VaultList: " + this.getVaultList() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVaultsResult)) {
            return false;
        }
        ListVaultsResult other = (ListVaultsResult)obj;
        if (other.getVaultList() == null ^ this.getVaultList() == null) {
            return false;
        }
        if (other.getVaultList() != null && !other.getVaultList().equals(this.getVaultList())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVaultList() == null ? 0 : this.getVaultList().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListVaultsResult clone() {
        try {
            return (ListVaultsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

