/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.CreateJobPlaylist;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobOutputJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobPlaylistJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobInputJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateJobRequest> request = new DefaultRequest<CreateJobRequest>(createJobRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2012-09-25/jobs";
        request.setResourcePath(uriResourcePath);
        try {
            SdkInternalMap userMetadataMap;
            SdkInternalList playlistsList;
            SdkInternalList outputsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createJobRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("PipelineId").writeValue(createJobRequest.getPipelineId());
            }
            if (createJobRequest.getInput() != null) {
                jsonGenerator.writeFieldName("Input");
                JobInputJsonMarshaller.getInstance().marshall(createJobRequest.getInput(), jsonGenerator);
            }
            if (createJobRequest.getOutput() != null) {
                jsonGenerator.writeFieldName("Output");
                CreateJobOutputJsonMarshaller.getInstance().marshall(createJobRequest.getOutput(), jsonGenerator);
            }
            if (!(outputsList = (SdkInternalList)createJobRequest.getOutputs()).isEmpty() || !outputsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Outputs");
                jsonGenerator.writeStartArray();
                for (Object outputsListValue : outputsList) {
                    if (outputsListValue == null) continue;
                    CreateJobOutputJsonMarshaller.getInstance().marshall((CreateJobOutput)outputsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createJobRequest.getOutputKeyPrefix() != null) {
                jsonGenerator.writeFieldName("OutputKeyPrefix").writeValue(createJobRequest.getOutputKeyPrefix());
            }
            if (!(playlistsList = (SdkInternalList)createJobRequest.getPlaylists()).isEmpty() || !playlistsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Playlists");
                jsonGenerator.writeStartArray();
                for (Object playlistsListValue : playlistsList) {
                    if (playlistsListValue == null) continue;
                    CreateJobPlaylistJsonMarshaller.getInstance().marshall((CreateJobPlaylist)playlistsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(userMetadataMap = (SdkInternalMap)createJobRequest.getUserMetadata()).isEmpty() || !userMetadataMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("UserMetadata");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : userMetadataMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

